import 'package:flutter/material.dart';
import 'package:jcs_airport/view/task/choose_list.dart';
import 'package:jcs_airport/consts/styles.dart';
import 'package:get/get.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

/// 下拉框
Widget buildDynamicSelect(
    BuildContext context,
    Map<String, dynamic> formData,
    Map<String, dynamic> visualParams,
    Map<String, dynamic> formValidator,
    bool editable) {
  String dataType = visualParams['dataType'];
  if (dataType == 'api') {
    return _BuildComplexSelectWidget(
        formData: formData,
        visualParams: visualParams,
        formValidator: formValidator,
        editable: editable);
  }
  return _BuildSimpleSelectWidget(
      formData: formData,
      visualParams: visualParams,
      formValidator: formValidator,
      editable: editable);
}

class _BuildSimpleSelectWidget extends StatefulWidget {
  final Map<String, dynamic> formData;
  final Map<String, dynamic> visualParams;
  final Map<String, dynamic> formValidator;
  final bool editable;

  const _BuildSimpleSelectWidget({
    this.formData,
    this.visualParams,
    this.formValidator,
    this.editable,
  });

  @override
  State<StatefulWidget> createState() => _BuildSimpleSelectWidgetState();
}

class _BuildSimpleSelectWidgetState extends State<_BuildSimpleSelectWidget> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      child: Padding(
        padding: const EdgeInsets.symmetric(horizontal: 15),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(widget.visualParams['label']),
            const SizedBox(
              height: 5,
            ),
            TextField(
              controller: TextEditingController(
                  text: widget.formData[widget.visualParams['fieldKey']] ?? ''),
              readOnly: true,
              style: const TextStyle(fontSize: CoreStyles.textSizeSmall),
              decoration: InputDecoration(
                filled: true,
                fillColor: FormStyles.CONTENT_COLOR,
                border: InputBorder.none,
                suffixIcon: Transform.translate(
                  offset: const Offset(5, 0),
                  child: const Icon(
                    Icons.arrow_right,
                    color: Colors.black87,
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
      onTap: () {
        if (!widget.editable) {
          return;
        }
        showDialog(
            context: context,
            builder: (BuildContext context) {
              return SimpleDialog(
                  contentPadding: const EdgeInsets.symmetric(vertical: 10),
                  children: List.generate(widget.visualParams['data'].length,
                          (index) {
                        return Column(children: [
                          SimpleDialogOption(
                            child: Center(
                                child: Text(
                                    widget.visualParams['data'][index]['name'])),
                            onPressed: () {
                              setState(() {
                                widget.formData[widget.visualParams['fieldKey']] =
                                widget.visualParams['data'][index]['name'];
                              });
                              Get.back();
                            },
                          ),
                          const Divider(
                            height: 1,
                          )
                        ]);
                      }));
              // 'List<dynamic>' is not a subtype of type 'List<Widget>'
            });
      },
    );
  }
}

class _BuildComplexSelectWidget extends StatefulWidget {
  final Map<String, dynamic> formData;
  final Map<String, dynamic> visualParams;
  final Map<String, dynamic> formValidator;
  final bool editable;

  const _BuildComplexSelectWidget({
    this.formData,
    this.visualParams,
    this.formValidator,
    this.editable,
  });

  @override
  State<StatefulWidget> createState() => _BuildComplexSelectWidgetState();
}

class _BuildComplexSelectWidgetState extends State<_BuildComplexSelectWidget> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FormItem(
        layout: FormLayout.vertical,
        label: widget.visualParams['label'],
        formfield: widget.editable
            ? SelectFormNewPage(
            value: widget.formData[widget.visualParams['fieldKey']] ?? '',
            selectPage: ChooseList(
              person: {
                widget.visualParams['api']['ruleData']['nameKey']:
                widget.formData[widget.visualParams['fieldKey']]
              },
              api: widget.visualParams['api'],
            ),
            onChanged: (val) {
              setState(() {
                widget.formData[widget.visualParams['fieldKey']] =
                val[widget.visualParams['api']['ruleData']['nameKey']];
              });
            })
            : TextField(
          controller: TextEditingController(
              text:
              widget.formData[widget.visualParams['fieldKey']] ?? ''),
          style: const TextStyle(fontSize: CoreStyles.textSizeSmall),
          readOnly: true,
          decoration: InputDecoration(
            filled: true,
            fillColor: FormStyles.CONTENT_COLOR,
            border: InputBorder.none,
            suffixIcon: Transform.translate(
              offset: const Offset(5, 0),
              child: const Icon(
                Icons.arrow_right,
                color: Colors.black87,
              ),
            ),
          ),
        ));
  }
}
