import 'package:flutter/material.dart';
import './timeline_entity.dart';
import './timeline_tail.dart';

String processTitle(String str) {
  return str.length > 47 ? str.substring(0, 47) + "..." : str;
}

/// 时间线 item
class TimelineItem extends StatelessWidget {
  final Color lineColor;
  final Color dotColor;
  final Color backgroundColor;
  final TimelineEntity model;
  final bool firstElement;
  final bool lastElement;

  /// 通用文本字体颜色
  final Color textColor;

  const TimelineItem(
      {@required this.lineColor,
        @required this.dotColor,
        @required this.backgroundColor,
        @required this.model,
        this.firstElement = false,
        this.lastElement = false,
        this.textColor});

  Widget _buildLine(BuildContext context) {
    return Container(
      width: 40.0,
      padding: EdgeInsets.only(top: 3.0),
      child: TimelineTail(
          lineColor: lineColor,
          dotColor: dotColor,
          backgroundColor: backgroundColor),
    );
  }

  /// 内容区
  Widget _buildContentColumn(BuildContext context) {
    return Container(
        margin: EdgeInsets.only(bottom: 6.0),
        decoration: BoxDecoration(
            border: Border(bottom: BorderSide(width: 0.5, color: Colors.grey))),
        child: Column(
          mainAxisSize: MainAxisSize.max,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            new Container(
              child: new Text(
                processTitle(model.statusStr ?? model.status),
                style: new TextStyle(
                  fontWeight: FontWeight.bold,
                  fontSize: 15,
                  color: dotColor != null ? dotColor : Colors.black,
                ),
              ),
            ),

            Expanded(
              child: Align(
                alignment: Alignment.topLeft,
                child: new Text(
                  processTitle(model.title),
                  style: new TextStyle(
                    fontWeight: FontWeight.bold,
                    color: textColor != null ? textColor : Colors.black87,
                  ),
                ),
              ),
            )
          ],
        ));
  }

  /// 行
  Widget _buildRow(BuildContext context) {
    return Container(
      constraints: BoxConstraints(minHeight: 30, maxHeight: 50.0),
      color: backgroundColor,
      padding: EdgeInsets.symmetric(horizontal: 12.0),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.stretch,
        children: <Widget>[
          _buildLine(context),
          Expanded(
            child: _buildContentColumn(context),
          ),
        ],
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return _buildRow(context);
  }
}
