import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/consts/styles.dart';
import 'package:jcs_airport/services/api.dart';

///选择业主单位
class ChooseMaintenanceMasterDepartment extends StatefulWidget {
  final Map chooseDepartment;

  const ChooseMaintenanceMasterDepartment({this.chooseDepartment});

  @override
  _ChooseMaintenanceMasterDepartmentState createState() => _ChooseMaintenanceMasterDepartmentState();
}

class _ChooseMaintenanceMasterDepartmentState extends State<ChooseMaintenanceMasterDepartment> {
  List departments = [];
  final GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey<ScaffoldState>();

  @override
  void initState() {
    super.initState();
    initData();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      resizeToAvoidBottomInset: false,
      key: _scaffoldKey,
      appBar: AppBar(
        title: const Text('请选择'),
      ),
      body: Column(
        children: [
          Expanded(
            child: departments.isNotEmpty ? buildListView(departments) : Container(),
          ),
          Container(
            padding: const EdgeInsets.all(10),
            child: Row(
              children: [
                Expanded(
                  child: FlatButton(
                    color: Theme.of(context).primaryColor,
                    height: 40,
                    onPressed: () {
                      Navigator.pop(context, widget.chooseDepartment);
                    },
                    child: const Text(
                      '确定',
                      style: TextStyle(color: Colors.white),
                    ),
                  ),
                ),
              ],
            ),
          )
        ],
      ),
    );
  }

  ListView buildListView(List department) {
    return ListView.builder(
        shrinkWrap: true,
        itemBuilder: (BuildContext context, int index) {
          return InkWell(
            onTap: () {
              setState(() {
                widget.chooseDepartment.addAll(department[index]);
              });
            },
            child: department[index]['children'] != null && department[index]['children'].length > 0
                ? Row(
                    children: [
                      Checkbox(
                          value: department[index]['sequenceNbr'] == widget.chooseDepartment['sequenceNbr'],
                          onChanged: (value) {
                            setState(() {
                              widget.chooseDepartment.addAll(department[index]);
                            });
                          }),
                      Expanded(
                        child: CollapseCard(
                          defaultExpanded: false,
                          title: Text(
                            department[index]['bizOrgName'] ?? '',
                            style: const TextStyle(fontSize: CoreStyles.textSizeSmall),
                          ),
                          children: [buildListView(department[index]['children'])],
                        ),
                      ),
                    ],
                  )
                : Row(
                    children: [
                      Checkbox(
                          value: department[index]['sequenceNbr'] == widget.chooseDepartment['sequenceNbr'],
                          onChanged: (value) {
                            setState(() {
                              widget.chooseDepartment.addAll(department[index]);
                            });
                          }),
                      Expanded(
                          child: ListTile(
                              title: Text(
                        department[index]['bizOrgName'] ?? '',
                        style: const TextStyle(fontSize: CoreStyles.textSizeSmall),
                      ))),
                    ],
                  ),
          );
        },
        itemCount: department.length);
  }

  Future<void> initData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.maintenanceCompany({'pageSize': 1});
      Get.back();
      setState(() {
        if (data != null) {
          departments = data['records'] ?? [];
        }
      });
    });
  }
}
