import 'package:amos_flutter_utils/date_utils.dart';
import 'package:amos_iot_ui/charts/annular_chart.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/routes/routes.dart';
import 'package:jcs_airport/services/api.dart';

///维保任务
class Calender extends StatefulWidget {
  const Calender({Key key}) : super(key: key);

  @override
  _CalenderState createState() => _CalenderState();
}

class _CalenderState extends State<Calender> {
  final List<SeriesData> _dataCount = [];

  //选择的日期
  String date;
  DateTime chooseDate;

  //统计总数
  int count = 0;

  @override
  void initState() {
    super.initState();
    date = DateUtils.formatDate(DateTime.now(), format: 'yyyy-MM-dd');
    _getData();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('维保日历'),
      ),
      body: Column(
        children: [
          Row(
            children: [
              Expanded(
                child: Card(
                  margin: const EdgeInsets.all(5),
                  child: SizedBox(
                      height: 200,
                      child: _dataCount.isNotEmpty
                          ? AnnularChart(_dataCount)
                          : Center(
                              child: Column(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Image.asset(
                                    'assets/images/no_data.png',
                                    width: 100,
                                  ),
                                  const SizedBox(
                                    height: 20,
                                  ),
                                  const Text(
                                    '当日暂无数据...',
                                    style: TextStyle(color: Colors.grey),
                                  ),
                                ],
                              ),
                            )),
                ),
              )
            ],
          ),
          Expanded(
            child: Card(
              child: CalendarDatePicker(
                initialCalendarMode: DatePickerMode.day,
                initialDate: chooseDate ?? DateTime.now(),
                onDateChanged: (val) async {
                  setState(() {
                    _dataCount.clear();
                    date = DateUtils.formatDate(val, format: 'yyyy-MM-dd');
                    chooseDate = val;
                  });
                  await _getData();
                  if (_dataCount.isNotEmpty) {
                    Get.toNamed(JCSRoutes.maintenanceRecord);
                  }
                },
                onDisplayedMonthChanged: (val) async {
                  setState(() {
                    _dataCount.clear();
                    date = DateUtils.formatDate(val, format: 'yyyy-MM-dd');
                    chooseDate = val;
                  });
                  await _getData();
                },
                lastDate: DateTime(2040),
                firstDate: DateTime(1970),
              ),
            ),
          )
        ],
      ),
    );
  }

  Future<void> _getData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.maintenanceRecordCalendar(date);
      Get.back();
      if (data != null) {
        setState(() {
          data['charData'].forEach((key, value) {
            int val = value ?? 0;
            if (val > 0) {
              _dataCount.add(SeriesData(val, key, Colors.green));
              count += val;
            }
          });
        });
      }
    });
  }
}
