import 'package:base/view/common/banner_page.dart';
import 'package:flutter/material.dart';
import 'package:jcs_airport/consts/styles.dart';
import 'package:jcs_airport/routes/routes.dart';
import 'package:get/get.dart';

///基本信息
class BaseInfo extends StatefulWidget {
  final Map _data;

  const BaseInfo(this._data);

  @override
  _BaseInfoState createState() => _BaseInfoState();
}

class _BaseInfoState extends State<BaseInfo> {
  int _index = 0;

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      child: Column(
        children: [
          Card(
            child: Column(
              children: [
                BannerWidget(
                  180.0,
                  [],
                  bannerPress: (pos, item) {
                    print('第 $pos 点击了');
                  },
                ),
                InkWell(
                  onTap: () => Get.toNamed(JCSRoutes.alarmInfo, arguments: widget._data['equipId'] ?? ''),
                  child: Padding(
                    padding: const EdgeInsets.all(15.0),
                    child: Column(
                      children: [
                        Row(
                          children: [
                            Text(
                              widget._data['name'] ?? '',
                              style: const TextStyle(fontSize: CoreStyles.textSizeSmall, fontWeight: FontWeight.bold),
                            ),
                            const SizedBox(
                              width: 50,
                            ),
                            /*Container(
                              decoration: const BoxDecoration(
                                  color: Colors.red, borderRadius: BorderRadius.all(Radius.circular(20))),
                              child: Text(
                                widget._data['name'] ?? '',
                                style: const TextStyle(fontSize: CoreStyles.textSizeMin, color: Colors.white),
                              ),
                              padding: const EdgeInsets.symmetric(horizontal: 8, vertical: 0.5),
                              margin: const EdgeInsets.only(top: 4),
                            ),*/
                          ],
                        ),
                        const SizedBox(
                          height: 5,
                        ),
                        Row(
                          children: [
                            Expanded(
                              child: Row(
                                children: [
                                  const Text('实时状态：'),
                                  Text(
                                    widget._data[''] ?? '',
                                  ),
                                ],
                              ),
                            ),
                            const Icon(
                              Icons.arrow_forward_ios,
                              color: Colors.blueAccent,
                              size: 15,
                            )
                          ],
                        ),
                        const SizedBox(
                          height: 5,
                        ),
                        Row(
                          children: [
                            const Text('更新时间：'),
                            Text(
                              widget._data['recDate'] ?? '',
                            ),
                          ],
                        ),
                        const SizedBox(
                          height: 5,
                        ),
                        Row(
                          children: [
                            const Text('编        码：'),
                            Text(
                              widget._data['equipCode'] ?? '',
                            ),
                          ],
                        )
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
          Card(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  height: 35,
                  padding: const EdgeInsets.symmetric(horizontal: 15),
                  color: const Color(0xff00ccff),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: const [
                      Expanded(
                        child: Text(
                          '基本信息',
                        ),
                      ),
                    ],
                  ),
                ),
                _buildRow('名        称:', widget._data['name'] ?? ''),
                _buildRow('地        址:', widget._data['address'] ?? ''),
                _buildRow('所在建筑:', widget._data['belongBuilding'] ?? ''),
                _buildRow('所属消防系统:', widget._data['belongFightingSystem'] ?? ''),
                _buildRow('管理单位:', widget._data[''] ?? ''),
                _buildRow('维保单位:', widget._data[''] ?? ''),
                _buildRow('联  系  人:', widget._data['contactUser'] ?? ''),
                _buildRow('联系人电话:', widget._data['contactPhone'] ?? ''),
                _buildRow('建造日期:', widget._data['buildDate'] ?? ''),
                _buildRow('启用日期:', widget._data['enableDate'] ?? ''),
              ],
            ),
          )
        ],
      ),
    );
  }

  Widget _buildRow(String title, String value) {
    return Container(
      height: 35,
      padding: const EdgeInsets.symmetric(horizontal: 15),
      color: _index++ % 2 == 0 ? Colors.white : const Color(0xffefeff4),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [Expanded(child: Text(title)), Expanded(flex: 2, child: Text(value))],
      ),
    );
  }
}
