import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/services/api.dart';

///上报审核
class ReportAudit extends StatefulWidget {
  final String sequenceNbr;

  const ReportAudit(this.sequenceNbr);

  @override
  _ReportAuditState createState() => _ReportAuditState();
}

class _ReportAuditState extends State<ReportAudit> {
  final GlobalKey<FormState> _formKey = GlobalKey<FormState>();
  Map<String, Object> submitData = {};

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('故障设备报修单审核'),
      ),
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Expanded(
            child: Form(
              key: _formKey,
              child: FormItem(
                label: '审核意见:',
                formfield: ITextFormField(
                    maxLines: 4,
                    validator: ValidatorMulti([ValidatorRequired(errorText: '请输入审核意见')]),
                    hintText: '请输入审核意见',
                    onChanged: (val) {
                      submitData['auditOpinion'] = val;
                    }),
              ),
            ),
          ),
          Container(
            padding: const EdgeInsets.all(15),
            child: Row(
              children: [
                Expanded(
                    child: FlatButton(
                  color: const Color.fromRGBO(200, 200, 200, 1),
                  height: 40,
                  onPressed: () {
                    onSubmit(context, 2);
                  },
                  child: const Text(
                    '退回编辑人',
                    style: TextStyle(color: Colors.white),
                  ),
                )),
                const SizedBox(
                  width: 3,
                ),
                Expanded(
                    child: FlatButton(
                  color: const Color.fromRGBO(200, 200, 200, 1),
                  height: 40,
                  onPressed: () {
                    onSubmit(context, 1);
                  },
                  child: const Text(
                    '不同意',
                    style: TextStyle(color: Colors.red),
                  ),
                )),
                const SizedBox(
                  width: 3,
                ),
                Expanded(
                    child: FlatButton(
                  color: Colors.blueAccent,
                  height: 40,
                  onPressed: () {
                    onSubmit(context, 0);
                  },
                  child: const Text(
                    '同意',
                    style: TextStyle(color: Colors.white),
                  ),
                )),
              ],
            ),
          ),
        ],
      ),
    );
  }

  void onSubmit(BuildContext context, int type) {
    if (_formKey.currentState.validate()) {
      submitData['condition'] = type;
      submitData['faultId'] = widget.sequenceNbr;
      MsgBox.showConfirmDialog(context, submit);
    }
  }

  Future<void> submit() async {
    MsgBox.showProgressDialog(context);
    var result = await API.failureAuditSave(submitData);
    Get.back();
    if (result != null && result == true) {
      Get.back();
    } else {
      ToastUtils.showToast('响应异常，提交失败！！');
    }
  }
}
