import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:intl/intl.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:jcs_airport/utils/GetConfig.dart';
import 'package:jcs_airport/consts/colors.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/viewmodel/alarm_info.dart';

class FilterPage extends StatefulWidget {
  const FilterPage(this.facilityFilter, {this.callback});

  final callback;
  final AlarmInfo facilityFilter;

  @override
  State<StatefulWidget> createState() => _FilterPageState();
}

class _FilterPageState extends State<FilterPage> {
  String _startDate = '';
  String _endDate = '';
  String _fireEquipmentName = '';
  String _fireEquipmentCode = '';
  String _confirmUserId = '';
  String _confirmUserName = '';
  String _jcsConfirmUserName='';
  String theme = '';
  List confirmUserList = [];

  @override
  void initState() {
    super.initState();
    if (widget.facilityFilter != null) {

      _startDate=widget.facilityFilter.startDate??'';
      _endDate= widget.facilityFilter.endDate??'' ;
      _fireEquipmentCode= widget.facilityFilter.fireEquipmentCode ??'';
      _confirmUserId=widget.facilityFilter.confirmUserId ??'';
      _fireEquipmentName=widget.facilityFilter.fireEquipmentName??'';
      _confirmUserName=widget.facilityFilter.confirmUserNamename ??'';

    }
    initConfig();
    getDeptUserList();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('报警信息筛选')),
      body: Column(
        children: [
          Expanded(
            child: ListView.builder(
                itemCount: 1,
                itemBuilder: (BuildContext context, int index) {
                  return Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                    Container(
                        padding: const EdgeInsets.only(left: 10),
                        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                          const Padding(padding: EdgeInsets.only(top: 15)),
                          const Text('设备名称'),
                          const Padding(padding: EdgeInsets.only(top: 5)),
                          GestureDetector(
                              child: Container(
                                  height: 40,
                                  width: MediaQuery.of(context).size.width - 20,
                                  padding: const EdgeInsets.only(bottom: 5),
                                  decoration: BoxDecoration(color: Colors.grey[100]),
                                  child: Stack(children: <Widget>[
                                    Container(
                                        alignment: Alignment.centerLeft,
                                        padding: const EdgeInsets.only(left: 5),
                                        child: TextField(
                                          // controller:  TextEditingController(text: _fireEquipmentName),
                                            controller: TextEditingController.fromValue(TextEditingValue(
                                              // 设置内容
                                                text: _fireEquipmentName,
                                                // 保持光标在最后
                                                selection: TextSelection.fromPosition(TextPosition(
                                                    affinity: TextAffinity.downstream,
                                                    offset: _fireEquipmentName.length)))),


                                            onChanged: (value) {
                                          setState(() {
                                            _fireEquipmentName = value;
                                          });
                                        }))
                                  ])))
                        ])),
                    Container(
                        padding: const EdgeInsets.only(left: 10),
                        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                          const Padding(padding: EdgeInsets.only(top: 15)),
                          const Text('设备编码'),
                          const Padding(padding: EdgeInsets.only(top: 5)),
                          GestureDetector(
                              child: Container(
                                  height: 40,
                                  width: MediaQuery.of(context).size.width - 20,
                                  padding: const EdgeInsets.only(bottom: 5),
                                  decoration: BoxDecoration(color: Colors.grey[100]),
                                  child: Stack(children: <Widget>[
                                    Container(
                                        alignment: Alignment.centerLeft,
                                        padding: const EdgeInsets.only(left: 5),
                                        child: TextField(                                         
                                          // controller:  TextEditingController(
                                          //     text: _fireEquipmentCode
                                          // ),

                                            controller: TextEditingController.fromValue(TextEditingValue(
                                              // 设置内容
                                                text: _fireEquipmentCode,
                                                // 保持光标在最后
                                                selection: TextSelection.fromPosition(TextPosition(
                                                    affinity: TextAffinity.downstream,
                                                    offset: _fireEquipmentCode.length)))),




                                          onChanged: (value) {
                                          setState(() {
                                            _fireEquipmentCode = value;
                                          });
                                        }))
                                  ])))
                        ])),


                    Container(
                        padding: const EdgeInsets.only(left: 10),
                        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                          const Padding(padding: EdgeInsets.only(top: 15)),
                          const Text('处理人'),
                          const Padding(padding: EdgeInsets.only(top: 5)),
                          GestureDetector(
                              child: Container(
                                  height: 40,
                                  width: MediaQuery.of(context).size.width - 20,
                                  padding: const EdgeInsets.only(bottom: 5),
                                  decoration: BoxDecoration(color: Colors.grey[100]),
                                  child: Stack(children: <Widget>[
                                    Container(
                                        alignment: Alignment.centerLeft,
                                        padding: const EdgeInsets.only(left: 5),
                                        child: Text(_confirmUserName)),
                                    Container(
                                        alignment: Alignment.centerRight,
                                        child: Icon(Icons.keyboard_arrow_right, size: 14, color: GetConfig.getColor(theme)))
                                  ])),
                              onTap: () {
                                showDialog<Null>(
                                  context: context,
                                  builder: (BuildContext context) {
                                    return SimpleDialog(
                                        children: confirmUserList.map((f) {
                                      return Column(
                                        children: <Widget>[
                                          SimpleDialogOption(
                                            child: Text(f['jcsConfirmUserName']),
                                            onPressed: () {
                                              Navigator.of(context).pop();
                                              // print(f['jcsConfirmUserName']);
                                              setState(() {
                                                _confirmUserId = f['confirmUser'].toString();
                                                _confirmUserName = f['jcsConfirmUserName'].toString();
                                                _jcsConfirmUserName=f['confirmUserName'].toString();
                                              });
                                            },
                                          ),
                                          const Divider(
                                            height: 1,
                                          )
                                        ],
                                      );
                                    }).toList());
                                  },
                                );
                              })
                        ])),


                        


                    Container(
                        padding: const EdgeInsets.only(left: 10),
                        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                          const Padding(padding: EdgeInsets.only(top: 15)),
                          const Text('开始时间'),
                          const Padding(padding: EdgeInsets.only(top: 5)),
                          InputDatePicker(
                              value: _startDate,
                              onChange: (date) {
                                setState(() {
                                  _startDate = DateFormat('yyyy-MM-dd').format(date);
                                });
                              }),
                        ])),
                    Container(
                        padding: const EdgeInsets.only(left: 10),
                        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                          const Padding(padding: EdgeInsets.only(top: 15)),
                          const Text('结束时间'),
                          const Padding(padding: EdgeInsets.only(top: 5)),
                          InputDatePicker(
                              value: _endDate,
                              onChange: (date) {
                                setState(() {
                                  _endDate = DateFormat('yyyy-MM-dd').format(date);
                                });
                              })
                        ]))
                  ]);
                }),
          ),
          Padding(
            padding: const EdgeInsets.all(8.0),
            child: Row(children: <Widget>[
              Expanded(
                child: OutlinedButton(
                    onPressed: () {
                setState(() {                
                    _startDate='';
                    _endDate= '' ;
                    _fireEquipmentCode= '';
                    _confirmUserId='';
                    _fireEquipmentName='';
                    _confirmUserName='';
                

                    widget.facilityFilter.startDate='';
                    widget.facilityFilter.endDate='' ;
                    widget.facilityFilter.fireEquipmentCode='';
                    widget.facilityFilter.confirmUserId ='';
                    widget.facilityFilter.fireEquipmentName='';
                    widget.facilityFilter.confirmUserNamename='';
                });

                    },
                    child: const Text('重置')),
              ),
              const SizedBox(
                width: 5,
              ),
              Expanded(
                child: RaisedButton(
                  color: Theme.of(context).primaryColor,
                  onPressed: () {
                    // widget.facilityFilter.startDate =_startDate;
                    widget.facilityFilter.startDate =_startDate + ' 00:00:00';

                    // widget.facilityFilter.endDate = _endDate;
                    widget.facilityFilter.endDate = _endDate + ' 23:59:59';
                    widget.facilityFilter.fireEquipmentCode = _fireEquipmentCode;
                    widget.facilityFilter.confirmUserName = _jcsConfirmUserName;
                    widget.facilityFilter.fireEquipmentName = _fireEquipmentName;
                    widget.facilityFilter.confirmUserId=_confirmUserId;
                    widget.facilityFilter.confirmUserNamename=_confirmUserName;
                    widget.callback(widget.facilityFilter);
                    Navigator.pop(context);

                    widget.facilityFilter.startDate ='';
                    widget.facilityFilter.endDate ='';
                  },
                  child: const Text(
                    '确定',
                    style: TextStyle(color: Colors.white),
                  ),
                ),
              )
            ]),
          )
        ],
      ),
    );
  }

  void getDeptUserList() {
    API.agencygetConfirmUser().then((persons) => {
      if (persons != null) {
            setState(() {
              confirmUserList.addAll(persons);
            })
          }
    });


    // API.agencyuserMe().then((userInfo) {
    //   print('');
    //   userInfo['companys'].forEach((element) async {
    //     API.agencyuserByCompany(element['sequenceNbr']).then((persons) {
    //       if (persons != null) {
    //         setState(() {
    //           confirmUserList.addAll(persons);
    //         });
    //       }
    //     });
    //   });
    // });


  }
}
