import 'package:flutter/material.dart';
import 'package:base/consts/color.dart';
import 'package:get/get.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:equipment_manage/view/vehicledetails/vehicle_specification.dart';
import 'package:equipment_manage/view/vehicledetails/vehicle_technical_documents.dart';
import 'package:equipment_manage/view/vehicledetails/vehicle_supplier.dart';
import 'package:equipment_manage/model/vehicle_basic_model.dart';
import 'package:jcs_airport/view/workBench/maintenance/maintenanceEquipment/equipmentDetail/maintenance_tab_info.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/viewmodel/facility_filter.dart';
import './facility_basic.dart';

/// 装备设施主组件
class FacilityTab extends StatefulWidget {
  //维保数据
  final Map equipmentCategory;

  const FacilityTab({Key key, this.equipmentCategory}) : super(key: key);

  @override
  _FacilityTabState createState() => _FacilityTabState();
}

class _FacilityTabState extends State<FacilityTab>
    with SingleTickerProviderStateMixin {
  TabController _tabController;
  BasicBean basicBean = BasicBean();
  String type = '1'; //1为装备 3为车辆
  String theme;
  FacilityFilter equipmentCategory = FacilityFilter();

  @override
  void initState() {
    super.initState();
    print(Get.arguments);
    if(Get.arguments != null){
      equipmentCategory = FacilityFilter.fromJson1(Get.arguments);
    }else {
      equipmentCategory = FacilityFilter.fromJson1(widget.equipmentCategory);
    }
    setState(() {});
    _tabController = TabController(
        vsync: this, length: equipmentCategory == null ? 4 : 5);
    initConfig();
    getEquipmentDetail();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
            title: Text('设备详情',
                style: Theme.of(context).appBarTheme.textTheme.headline1),
            bottom: TabContainer(
                width: double.infinity,
                height: 42,
                color: Colors.white,
                child: Center(
                    // 剧中布局
                    child: TabBar(

                        /// 设置选中时的字体颜色，tabs里面的字体样式优先级最高
                        labelColor: Colors.blue,

                        /// 设置未选中时的字体颜色，tabs里面的字体样式优先级最高
                        unselectedLabelColor: Colors.black,

                        /// 允许左右滚动
                        isScrollable: true,

                        /// 选中下划线的颜色
                        indicatorColor: Colors.lightBlue,

                        /// 选中下划线的长度，label时跟文字内容长度一样，tab时跟一个Tab的长度一样
                        indicatorSize: TabBarIndicatorSize.label,

                        /// 选中下划线的高度，值越大高度越高，默认为2。0
                        indicatorWeight: 2.0,
                        tabs: [
                          const Tab(text: '基本信息'),
                          const Tab(text: '详细参数'),
                          const Tab(text: '技术文档'),
                          const Tab(text: '供应商'),
                        ]..addIf(equipmentCategory != null,
                            const Tab(text: '维保信息')),
                        controller: _tabController)))),
        body: TabBarView(
            controller: _tabController,
            children: [
              SingleChildScrollView(
                  child: Padding(
                      padding: const EdgeInsets.all(8),
                      child: Container(
                          child: basicBean.equipmentBase != null
                              ? FacilityBasic(basicBean)
                              : null))),

              /// 基本信息
              SingleChildScrollView(
                  child: Padding(
                      padding: const EdgeInsets.all(8),
                      child: Card(
                          child: Container(
                              child: SpecificaPage(basicBean, type))))),

              ///详细参数
              SingleChildScrollView(
                  child: Padding(
                      padding: const EdgeInsets.all(8),
                      child: Card(
                          child: Container(
                              child: TechnicalPage(basicBean, type))))),

              /// 技术文档
              SingleChildScrollView(
                  child: Padding(
                      padding: const EdgeInsets.all(8),
                      child: Card(
                          child: Container(
                              child: SupplierPage(basicBean, type))))),

              /// 供应商
            ]..addIf(equipmentCategory != null,
                MaintenanceTabInfo(equipmentCategory,equipmentCategory.fireFacilityCode))));
  }

  getEquipmentDetail() {
    API.getEquipmentDetail(equipmentCategory.fireFacilityCode).then((res) {
      setState(() {
        basicBean = BasicBean.fromJson(res['equipmentBase']);
        basicBean.equipmentBase = EquipmentBase.fromJson(res['equipmentBase']);
        List excel = <Instruction>[];
        res['excel'].forEach((v) {
          excel.add(Instruction.fromJson(v));
        });
        basicBean.excel = excel;
        dynamic manufacturerInfo = res['manufacturerInfo'];
        if (manufacturerInfo != null) {
          basicBean.manufacturerInfo =
              ManufacturerInfo.fromJson(manufacturerInfo);
        }

        if (res['equipmentIndexVOS'] != null) {
          List perfQuotaS = <CarPropertyList>[];
          res['equipmentIndexVOS'].forEach((v) {
            perfQuotaS.add(CarPropertyList.fromJson(v));
          });
          basicBean.perfQuotaS = perfQuotaS;
        }
      });
    }).catchError((_) {
      //Navigator.of(context).pop();
      ToastUtils.showToast('请重新选择');
    });
  }
}
