import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:intl/intl.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:jcs_airport/utils/GetConfig.dart';
import 'package:jcs_airport/consts/colors.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/viewmodel/monitor_event.dart';

class FilterPage extends StatefulWidget {
  const FilterPage(this.facilityFilter, {this.callback});

  final callback;
  final MonitorEvent facilityFilter;

  @override
  State<StatefulWidget> createState() => _FilterPageState();
}

class _FilterPageState extends State<FilterPage> {
  String _startDate = '';
  String _endDate = '';
  String _videoName = '';
  String _disposalUserId = '';
  String _disposalUserName = '';
  String theme = '';
  List confirmUserList = [];
  TextEditingController videoNameController = TextEditingController();

  @override
  void initState() {
    super.initState();
    if (widget.facilityFilter != null) {}
    initConfig();
    getDeptUserList();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('在岗监测信息筛选')),
      body: ListView.builder(
          itemCount: 1,
          itemBuilder: (BuildContext context, int index) {
            return Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
              Container(
                  padding: const EdgeInsets.only(left: 10),
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                    const Padding(padding: EdgeInsets.only(top: 15)),
                    const Text('设备名称'),
                    const Padding(padding: EdgeInsets.only(top: 5)),
                    GestureDetector(
                        child: Container(
                            height: 40,
                            width: MediaQuery.of(context).size.width - 20,
                            padding: const EdgeInsets.only(bottom: 5),
                            decoration: BoxDecoration(color: Colors.grey[100]),
                            child: Stack(children: <Widget>[
                              Container(
                                  alignment: Alignment.centerLeft,
                                  padding: const EdgeInsets.only(left: 5),
                                  child: TextField(
                                      controller: videoNameController,
                                      onChanged: (value) {
                                        setState(() {
                                          _videoName = value;
                                        });
                                      }))
                            ])))
                  ])),
              Container(
                  padding: const EdgeInsets.only(left: 10),
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                    const Padding(padding: EdgeInsets.only(top: 15)),
                    const Text('处理人'),
                    const Padding(padding: EdgeInsets.only(top: 5)),
                    GestureDetector(
                        child: Container(
                            height: 40,
                            width: MediaQuery.of(context).size.width - 20,
                            padding: const EdgeInsets.only(bottom: 5),
                            decoration: BoxDecoration(color: Colors.grey[100]),
                            child: Stack(children: <Widget>[
                              Container(
                                  alignment: Alignment.centerLeft,
                                  padding: const EdgeInsets.only(left: 5),
                                  child: Text(_disposalUserName)),
                              Container(
                                  alignment: Alignment.centerRight,
                                  child: Icon(Icons.keyboard_arrow_right, size: 14, color: GetConfig.getColor(theme)))
                            ])),
                        onTap: () {
                          showDialog<Null>(
                            context: context,
                            builder: (BuildContext context) {
                              return SimpleDialog(
                                  children: confirmUserList.map((f) {
                                return Column(
                                  children: <Widget>[
                                    SimpleDialogOption(
                                      child: Text(f['realName']),
                                      onPressed: () {
                                        Navigator.of(context).pop();
                                        print(f['realName']);
                                        setState(() {
                                          _disposalUserId = f['userId'].toString();
                                          _disposalUserName = f['realName'].toString();
                                        });
                                      },
                                    ),
                                    const Divider(
                                      height: 1,
                                    )
                                  ],
                                );
                              }).toList());
                            },
                          );
                        })
                  ])),
              Container(
                  padding: const EdgeInsets.only(left: 10),
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                    const Padding(padding: EdgeInsets.only(top: 15)),
                    const Text('开始时间'),
                    const Padding(padding: EdgeInsets.only(top: 5)),
                    InputDatePicker(
                        value: _startDate,
                        onChange: (date) {
                          setState(() {
                            _startDate = DateFormat('yyyy-MM-dd').format(date);
                          });
                        }),
                  ])),
              Container(
                  padding: const EdgeInsets.only(left: 10),
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                    const Padding(padding: EdgeInsets.only(top: 15)),
                    const Text('结束时间'),
                    const Padding(padding: EdgeInsets.only(top: 5)),
                    InputDatePicker(
                        value: _endDate,
                        onChange: (date) {
                          setState(() {
                            _endDate = DateFormat('yyyy-MM-dd').format(date);
                          });
                        })
                  ]))
            ]);
          }),
      persistentFooterButtons: <Widget>[
        Row(children: <Widget>[
          Container(
              width: (MediaQuery.of(context).size.width / 2) - 13,
              height: 40,
              color: const Color.fromRGBO(242, 246, 249, 1),
              child: OutlinedButton(
                  onPressed: () {
                    setState(() {
                      _startDate = '';
                      _endDate = '';
                      _videoName = '';
                      _disposalUserId = '';
                      _disposalUserName = '';
                      videoNameController.text = '';
                    });
                  },
                  child: const Text('重置', style: TextStyle(color: Colors.black, fontSize: 18)))),
          const SizedBox(
            width: 5,
          ),
          Container(
              width: (MediaQuery.of(context).size.width / 2) - 13,
              height: 40,
              color: Theme.of(context).primaryColor,
              child: MaterialButton(
                onPressed: () {
                  widget.facilityFilter.startDate = _startDate;
                  widget.facilityFilter.endDate = _endDate;
                  widget.facilityFilter.videoName = _videoName;
                  widget.facilityFilter.disposalUserId = _disposalUserId;
                  widget.facilityFilter.disposalUserName = _disposalUserName;
                  widget.callback(widget.facilityFilter);
                  Navigator.pop(context);
                },
                child: const Text('确定', style: TextStyle(color: Colors.white, fontSize: 18)),
              ))
        ])
      ],
      resizeToAvoidBottomPadding: false,
    );
  }

  void getDeptUserList() {
    API.agencyuserMe().then((userInfo) {
      print('');
      userInfo['companys'].forEach((element) async {
        API.agencyuserByCompany(element['sequenceNbr']).then((persons) {
          if (persons != null) {
            setState(() {
              confirmUserList.addAll(persons);
            });
          }
        });
      });
    });
  }
}
