import 'package:jcs_airport/viewmodel/monitor_event.dart';
import 'package:jcs_airport/utils/time.dart';

/// 时间查询条件
const List<Map<String, dynamic>> TIMES = [
  {'title': '全部', 'id': null, 'key': 'time'},
  {'title': '今天', 'id': '1', 'key': 'time'},
  {'title': '昨天', 'id': '2', 'key': 'time'},
  {'title': '本周', 'id': '3', 'key': 'time'},
  {'title': '上周', 'id': '4', 'key': 'time'},
  {'title': '本月', 'id': '5', 'key': 'time'},
  {'title': '上月', 'id': '6', 'key': 'time'},
];

/// 处理状态查询条件
const List<Map<String, dynamic>> PROCESS_STATUS = [
  {'title': '全部', 'id': null, 'key': 'eventState'},
  {'title': '未处理', 'id': '未处理', 'key': 'eventState'},
  {'title': '已处理', 'id': '已处理', 'key': 'eventState'},
];

/// 告警类型查询条件
const List<Map<String, dynamic>> EVENT_TYPE = [
  {'title': '全部', 'id': null, 'key': 'eventType'},
  {'title': '离岗', 'id': '离岗', 'key': 'eventType'},
  {'title': '人数异常', 'id': '人数异常', 'key': 'eventType'}
];

MonitorEvent getStartDateAndEndDate(MonitorEvent monitorEvent, String createDate){
  if (createDate == null){
    monitorEvent.startDate = null;
    monitorEvent.endDate = null;
  } else if (createDate == '1'){
    monitorEvent.startDate = TimeUtils.getDayBegin();
    monitorEvent.endDate = TimeUtils.getDayEnd();
  } else if (createDate == '2'){
    monitorEvent.startDate = TimeUtils.getBeginDayOfYesterday();
    monitorEvent.endDate = TimeUtils.getEndDayOfYesterDay();
  } else if (createDate == '3'){
    monitorEvent.startDate = TimeUtils.getBeginDayOfWeek();
    monitorEvent.endDate = TimeUtils.getEndDayOfWeek();
  } else if (createDate == '4'){
    monitorEvent.startDate = TimeUtils.getBeginDayOfBeforeWeek();
    monitorEvent.endDate = TimeUtils.getEndDayOfBeforeWeek();
  } else if (createDate == '5'){
    monitorEvent.startDate = TimeUtils.getBeginDayOfMonth();
    monitorEvent.endDate = TimeUtils.getEndDayOfMonth();
  } else if (createDate == '6'){
    monitorEvent.startDate = TimeUtils.getBeginDayOfBeforeMonth();
    monitorEvent.endDate = TimeUtils.getEndDayOfBeforeMonth();
  }
  return monitorEvent;
}

