/// @author ilex.h
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:flutter_swiper/flutter_swiper.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import './../../../../utils/orientation_helper.dart';
import './right_video_list.dart';
import './stream_video_page.dart';

/// 视频播放
///
class MonitorVideoDetail extends StatefulWidget {
  const MonitorVideoDetail({Key key}) : super(key: key);

  @override
  _MonitorVideoDetailState createState() => _MonitorVideoDetailState();
}

class _MonitorVideoDetailState extends State<MonitorVideoDetail> {
  /// 采用 state 设置 args，防止其它操作导致参数丢失，当前选中的 视频 item
  Map<String, dynamic> activeVideo = {};
  bool showList = false;
  bool showAppbar = false;

  @override
  void initState() {
    super.initState();
    setState(() {
      /// 初始的时候，从 args 中传入
      activeVideo = Get.arguments ?? {};
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    OrientationHelper.setLandscapeRight();
    String name = activeVideo['name'] ?? '视频';
    String url = activeVideo['url'];
    return Scaffold(
      /// body延伸到Toolbar上
      extendBodyBehindAppBar: true,
      appBar: showAppbar
          ? AppBar(
              title: Text(name),
              backgroundColor: const Color.fromRGBO(0, 0, 0, 0.8),
              elevation: 0,
              actions: <Widget>[
                TextButton.icon(
                  icon: const Icon(
                    AmosIcon.webcam,
                    color: Colors.white,
                  ),
                  label: const Text(
                    '切换',
                    style: TextStyle(color: Colors.white),
                  ),
                  onPressed: () {
                    setState(() {
                      showList = !showList;
                    });
                  },
                ),
              ],
            )
          : null,
      body: _buildVideo(context, url),
    );
  }

  Widget _buildVideo(BuildContext context, String url) {
    // String testUrl = 'http://11.11.16.12:83/openUrl/gOYr6Eg/live.m3u8'; /// 支持
    // String testUrl = 'rtmp://11.11.16.12:1935/live/openUrl/NFEqJXO'; /// 支持
    // String testUrl = 'rtsp://11.11.16.12:554/openUrl/MIiQyPu';
    // String testUrl = 'ws://11.11.16.12:559/openUrl/RDDgWw8';

    return Stack(children: [
      StreamMediaPlayer(
        url: url,
        toggleAppbar: toggleAppbar,
      ),
      showList ? ToggleVideoList(onChanged: handleChange) : Container()
    ]);
  }

  void handleChange(item) {
    setState(() {
      activeVideo = item;
    });
  }

  void toggleAppbar(bool toggle) {
    setState(() {
      showAppbar = toggle;
    });
  }
}

/// 支持左右滑动切换视频
class SwiperVideos extends StatefulWidget {
  const SwiperVideos({Key key, this.datas, this.activeItem, this.activeIndex}) : super(key: key);

  /// 当前列表
  final List datas;

  /// 选中的项
  final dynamic activeItem;
  final int activeIndex;

  @override
  _SwiperVideosState createState() => _SwiperVideosState();
}

class _SwiperVideosState extends State<SwiperVideos> {
  int _index = 0;

  @override
  void initState() {
    super.initState();
    setState(() {
      _index = widget.activeIndex;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      child: Swiper(
        autoplay: false,
        pagination: null,
        itemCount: widget.datas?.length ?? 0,
        index: _index,
        onIndexChanged: (index) {
          setState(() {
            _index = index;
          });
        },
        itemBuilder: (BuildContext context, int index) {
          return const MonitorVideoDetail();
        },
        control: const SwiperControl(),
      ),
    );
  }
}
