/// @author ilex.h

import 'package:flutter/material.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:get/get.dart';

import './../../../../entity/Page.dart';
import './../../../../services/api.dart';

/// 视频监控列表
class ToggleVideoList extends StatefulWidget {
  const ToggleVideoList({Key key, this.onChanged}) : super(key: key);

  final Function onChanged;

  @override
  _ToggleVideoListState createState() => _ToggleVideoListState();
}

class _ToggleVideoListState extends State<ToggleVideoList> {
  final List<Map<String, dynamic>> _data = [];

  final RefreshController _refreshController = RefreshController(initialRefresh: false);
  final AmosPage _page = AmosPage(current: 1);

  bool isCard = false;

  @override
  void initState() {
    super.initState();
    _getData();
  }

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: Alignment.centerRight,
      child: Container(
        padding: const EdgeInsets.symmetric(vertical: 10),
        margin: const EdgeInsets.symmetric(vertical: 35),
        decoration: const BoxDecoration(
          borderRadius: BorderRadius.all(Radius.circular(20)),
          color: Color.fromRGBO(0, 0, 0, 0.5),
        ),
        width: 250.00,
        child: _buildList(context),
      ),
    );
  }

  Widget _buildList(BuildContext context) {
    return SmartRefresher(
      enablePullDown: true,
      enablePullUp: true,
      controller: _refreshController,
      header: const WaterDropMaterialHeader(),
      footer: const ClassicFooter(),
      onRefresh: _onRefresh,
      onLoading: _onLoading,
      child: ListView.builder(
        itemCount: _data.length,
        shrinkWrap: true,
        itemBuilder: (BuildContext context, int index) {
          Map<String, dynamic> item = _data[index];
          String address = (item['address'] ?? '').toString();
          String name = (item['name'] ?? '').toString();
          return CommonCard(
            color: const Color.fromRGBO(0, 0, 0, 0.2),
            margin: const EdgeInsets.symmetric(vertical: 4.0, horizontal: 8.0),
            child: Padding(
              padding: const EdgeInsets.all(2.0),
              child: ListTile(
                  title: Text(
                    name,
                    style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 18.0, color: Colors.white),
                  ),
                  subtitle: Opacity(opacity: 0.7, child: Text(address, style: const TextStyle(color: Colors.white))),
                  leading: const Icon(
                    AmosIcon.webcam,
                    size: 28.0,
                    color: Colors.white,
                  ),
                  onTap: () {
                    /// 切换视频
                    if (widget.onChanged != null) {
                      widget.onChanged(item);
                    }
                  }),
            ),
          );
        },
      ),
    );
  }

  void _onRefresh() {
    _page.current = 1;
    _data.clear();
    _getData();
    _refreshController.refreshCompleted();
  }

  void _onLoading() {
    _page.current += 1;
    _getData();
    _refreshController.loadComplete();
  }

  Future<void> _getData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.equipMonitorVideoList(_page.current, _page.size);
      Get.back();
      if (data != null) {
        if ((data['records'] ?? []).length == 0) {
          _refreshController.loadNoData();
          return;
        }
        setState(() {
          _data.addAll(data['records'].cast<Map<String, dynamic>>());
        });
      }
      _refreshController.refreshCompleted();
      _refreshController.loadComplete();
    });
  }
}
