import 'dart:convert';

import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';

import '../view/index.dart';
import '../view/login/login.dart';
import '../view/login/select_company_role.dart';
import '../view/login/select_role_list.dart';
import '../view/login/service_config.dart';
import '../view/my/contact/contact_page.dart';
import '../view/my/pswdchange_page.dart';
import '../view/my/subscribe_page.dart';

Handler loginHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return Login();
});

Handler mainHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return Index();
});

Handler serviceConfigHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return ServiceConfig();
});
Handler selectCompanyRoleHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  final Map<String, dynamic> result = json.decode(params['extension'].first);
  return SelectCompanyRole(result);
});
Handler selectRoleListHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  final List list = json.decode(params['params'].first);
  final String title = params['title'].first;
  return SelectRoleList(list, title);
});
Handler pswdChangeHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return PswdChangePage();
});
Handler contactHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return ContactPage();
});
Handler subscribeHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return SubscribePage();
});
