import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../utils/GetConfig.dart';

class LeadingButton extends StatelessWidget {
  final Function onWillPop;
  final bool onWillScope;
  final String theme;
  const LeadingButton({
    this.theme,
    this.onWillPop,
    this.onWillScope = false,
  });

  @override
  Widget build(BuildContext context) {
    return IconButton(
      icon: const Icon(Icons.keyboard_arrow_left, size: 32),
      onPressed: () {
        if (onWillScope) {
          if (onWillPop != null) {
            onWillPop();
          }
        } else {
          Navigator.of(context).pop();
        }
      },
    );
  }
}
