import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../utils/GetConfig.dart';

class CommonAppBar extends AppBar {
  Widget title;
  Widget trailing;
  String theme;
  CommonAppBar({this.theme, this.title, this.trailing});

  @override
  Widget build(BuildContext context) {
    return AppBar(
      titleSpacing: 0,
      automaticallyImplyLeading: false,
      title: title,
      leading: IconButton(
        icon: Icon(Icons.arrow_back_ios),
        color: GetConfig.getColor(theme),
        onPressed: () {
          Navigator.of(context).pop();
        },
      ),
      actions: <Widget>[
        Container(
          padding: EdgeInsets.symmetric(horizontal: 10.px),
          child: trailing,
        )
      ],
    );
  }
}
