import 'package:equipment_manage/model/fire_agent_classification_model.dart';
import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../utils/GetConfig.dart';
import '../utils/request.dart';

class FireAgentEndDrawer extends StatefulWidget {
  // 分类code
  final String category;
  final ValueChanged<FireAgentClassificationModel> click;
  final String theme;

  FireAgentEndDrawer({this.category, this.click, this.theme});

  @override
  _FireAgentEndDrawerState createState() => _FireAgentEndDrawerState();
}

class _FireAgentEndDrawerState extends State<FireAgentEndDrawer> {
  List<FireAgentClassificationModel> data = [];
  bool hasError = false;

  double drawerWidth = 260.px;

  @override
  void initState() {
    super.initState();
    String code = widget.category;
    if (code == null) return;

    HttpRequest.queryClassificationFireAgent(code).then((res) {
      if (res["status"] == 200) {
        List items = res["result"];
        List<FireAgentClassificationModel> models = [];
        for (var json in items) {
          models.add(FireAgentClassificationModel.fromJson(json));
        }
        setState(() {
          data = models;
        });
      }
    }).catchError((err) {
      setState(() {
        hasError = true;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (hasError) {
      return Container(
        width: drawerWidth,
        color: Colors.white,
        child: Center(
          child: Text("请求数据失败!"),
        ),
      );
    } else if (data.length == 0) {
      return Container(
        width: drawerWidth,
        color: Colors.white,
        child: Center(
          child: CircularProgressIndicator(),
        ),
      );
    } else {
      return Container(
        width: drawerWidth,
        color: Colors.white,
        child: Column(
          children: <Widget>[
            Padding(
              padding:
                  EdgeInsets.only(top: MediaQuery.of(context).viewPadding.top),
              child: Text(
                "类别",
                style: Theme.of(context)
                    .textTheme
                    .headline4
                    .copyWith(fontSize: 15.px),
              ),
            ),
            Expanded(
              child: ListView(
                shrinkWrap: true,
                children: data.map((e) {
                  return InkWell(
                    onTap: () {
                      Navigator.of(context).pop();
                      if (widget.click != null) {
                        widget.click(e);
                      }
                    },
                    child: Padding(
                      padding: EdgeInsets.only(left: 20.px, bottom: 20.px),
                      child: Text(
                        e.name,
                        style: Theme.of(context)
                            .textTheme
                            .headline6
                            .copyWith(color: Color(0xFF333333)),
                      ),
                    ),
                  );
                }).toList(),
              ),
            ),
            Container(
              height: 40.px,
              width: double.infinity,
              child: RaisedButton(
                shape: BeveledRectangleBorder(),
                color: GetConfig.getColor(widget.theme),
                child: Text(
                  "重置",
                  style: Theme.of(context).textTheme.headline2,
                ),
                onPressed: () {
                  Navigator.of(context).pop();
                  if (widget.click != null) {
                    widget.click(null);
                  }
                },
              ),
            )
          ],
        ),
      );
    }
  }
}
