import 'package:flutter/material.dart';
import 'package:flutter_svg_provider/flutter_svg_provider.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';


class SearchBar extends StatelessWidget {
  final String title;
  final VoidCallback onTap;

  SearchBar({@required this.title, @required this.onTap});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 15.px),
        height: 30.px,
        decoration: ShapeDecoration(
            color: Colors.white.withOpacity(0.1),
            shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(15.px))),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: <Widget>[
            Text(
              title,
              style: Theme.of(context)
                  .textTheme
                  .subtitle1
                  .copyWith(color: Colors.white.withOpacity(0.5)),
            ),
            Image(
              image:
                  Svg("assets/images/home_bar_search.svg", size: Size(18, 18)),
            )
          ],
        ),
      ),
    );
  }
}
