import 'package:base/consts/external_assets_package_key.dart';
import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../model/car_scan_model.dart';
import '../model/equipment_scan_model.dart';

enum ToastPosition { top, center, bottom }

mixin EquipmentToast {
  static OverlayEntry _overlayEntry;
  static bool _showing = false;
  static ToastPosition toastPosition;
  static DateTime _startTime;
  static CarScanModel _carModel;
  static EquipmentScanModel _equipModel;
  static EquipmentScanModel _fireAgentModel;
  static String _position;

  //static List <dynamic> _equipList;
  static void show(BuildContext context,
      {EquipmentScanModel fireAgentModel,
      CarScanModel carModel,
      EquipmentScanModel equipModel,
      int duration = 3, // 默认2秒
      ToastPosition toastPosition,
      String position,
      Color background = const Color(0xB2000000),
      TextStyle textStyle = const TextStyle(fontSize: 16, color: Colors.white, backgroundColor: Colors.transparent),
      double backgroundRadius = 20,
      Border border}) async {
    OverlayState overlayState = Overlay.of(context);
    toastPosition = ToastPosition.bottom;
    _startTime = DateTime.now();
    _showing = true;
    _carModel = carModel;
    _equipModel = equipModel;
    _fireAgentModel = fireAgentModel;
    _position = position;
    // _equipList= equipModel!=null?(equipModel.equProperties.length>0?equipModel.equProperties.length:[]):(carModel.equProperties.length>0?carModel.equProperties.length:[]);
    String img = _carModel != null
        ? (_carModel.img == null ? "assets/images/defule.png" : _carModel.img)
        : (_equipModel.img == null ? "assets/images/defule.png" : _equipModel.img);
    // 转换对应的模型

    if (_overlayEntry == null) {
      _overlayEntry = OverlayEntry(
        builder: (BuildContext context) => ToastWidget(
            widget: Container(
              width: MediaQuery.of(context).size.width,
              child: Center(
                  child: Container(
                decoration: BoxDecoration(color: Colors.white.withOpacity(0.5), borderRadius: BorderRadius.circular(6)),
                width: MediaQuery.of(context).size.width - 20.px,
                child: _fireAgentModel != null
                    ? Row(
                        children: <Widget>[
                          Padding(
                            padding: EdgeInsets.only(left: 10.px, top: 10, bottom: 10),
                            child: ClipRRect(
                                borderRadius: BorderRadius.circular(15.px),
                                child: _fireAgentModel.img == null
                                    ? Image.asset(
                                        'assets/images/defule.png',
                                        package: ExternalAssetsPackageKey.BASE,
                                        width: 60.px,
                                        height: 80.px,
                                      )
                                    : Image.network(
                                        _fireAgentModel.img ?? '',
                                        width: 60.px,
                                        height: 80.px,
                                      )),
                          ),
                          Padding(
                            padding: EdgeInsets.symmetric(vertical: 10.px, horizontal: 10.px),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  _fireAgentModel.equipName ?? ' ',
                                  style: Theme.of(context).textTheme.headline2.copyWith(fontSize: 20),
                                ),
                                SizedBox(
                                  height: 5.px,
                                ),
                                Text(
                                  "入账数量:  ${_fireAgentModel.amount ?? ' '}${_fireAgentModel.unit}",
                                  style: Theme.of(context).textTheme.headline6.copyWith(color: Colors.white, fontSize: 16),
                                ),
                                Text(
                                  "标识码:  ${_fireAgentModel.qrCode ?? ' '}",
                                  style: Theme.of(context).textTheme.headline6.copyWith(color: Colors.white, fontSize: 16),
                                ),
                                SizedBox(
                                  height: 5.px,
                                ),
                              ],
                            ),
                          ),
                        ],
                      )
                    : Row(
                        children: <Widget>[
                          Padding(
                            padding: EdgeInsets.only(left: 10.px, top: 10, bottom: 10),
                            child: ClipRRect(
                                borderRadius: BorderRadius.circular(15.px),
                                child: img == 'assets/images/defule.png'
                                    ? Image.asset(
                                        'assets/images/defule.png',
                                        width: 60.px,
                                        height: 80.px,
                                      )
                                    : Image.network(
                                        img,
                                        width: 60.px,
                                        height: 80.px,
                                      )),
                          ),
                          Padding(
                            padding: EdgeInsets.symmetric(vertical: 10.px, horizontal: 10.px),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  '${_carModel?.equipName ?? _equipModel.equipName}',
                                  style: Theme.of(context).textTheme.headline2.copyWith(fontSize: 20),
                                ),
                                SizedBox(
                                  height: 5.px,
                                ),
                                Text(
                                  '数量:  ${_carModel?.amount ?? _equipModel.amount}${_carModel?.unit ?? _equipModel.unit}',
                                  style: Theme.of(context).textTheme.headline6.copyWith(color: Colors.white,fontSize: 16),
                                ),
                                Text(
                                  '标识码:  ${_carModel?.qrCode ?? _equipModel.qrCode}',
                                  style: Theme.of(context).textTheme.headline6.copyWith(color: Colors.white,fontSize: 16),
                                ),
                                SizedBox(
                                  height: 5.px,
                                ),
                                _carModel != null
                                    ? Text(
                                        '车辆编号：' + (_carModel.carNum ?? ' '),
                                        style: Theme.of(context).textTheme.headline6.copyWith(color: Colors.white, fontSize: 16),
                                        overflow: TextOverflow.ellipsis,
                                      )
                                    : (_equipModel.carNum != null
                                        ? Text(
                                            '车辆编号：' + _equipModel.carNum,
                                            style: Theme.of(context).textTheme.headline6.copyWith(color: Colors.white, fontSize: 16),
                                            overflow: TextOverflow.ellipsis,
                                          )
                                        : Container()
                                    )
                              ],
                            ),
                          ),
                        ],
                      ),
              )),
            ),
            toastPosition: toastPosition),
      );
      overlayState.insert(_overlayEntry);
    } else {
      //重新绘制UI，类似setState
      _overlayEntry.markNeedsBuild();
    }
    await Future.delayed(Duration(seconds: duration));
    if (DateTime.now().difference(_startTime).inSeconds >= duration) {
      // 如果当前时间与toast显示的开始时间差大于等于显示时间就消失 否则继续显示

      dismiss();
    }
  }

  static dismiss() async {
    if (!_showing) {
      return;
    }
    _showing = false;
    _overlayEntry?.remove();
    _overlayEntry = null;
  }
}

class ToastWidget extends StatelessWidget {
  ToastWidget({
    Key key,
    @required this.widget,
    this.toastPosition,
  }) : super(key: key);

  final Widget widget;
  final ToastPosition toastPosition;

  @override
  Widget build(BuildContext context) {
    return Positioned(
        top: buildToastPosition(context),
        child: Material(
          color: Colors.transparent,
          child: widget,
        ));
  }

  double buildToastPosition(context) {
    var top;
    if (toastPosition == ToastPosition.top) {
      top = MediaQuery.of(context).size.height * 1 / 4;
    } else if (toastPosition == ToastPosition.center) {
      top = MediaQuery.of(context).size.height * 2 / 5;
    } else {
      top = MediaQuery.of(context).size.height * 3 / 4 - 20.px;
    }
    return top;
  }
}
