import 'package:base/consts/external_assets_package_key.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:base/consts/color.dart';
import 'package:base/services/application.dart';
import 'package:base/widgets/back_button.dart';
import 'package:base/widgets/common_card_item.dart';
import 'package:flutter/material.dart';

import '../../routes/routes.dart';

class CommonSearchList extends StatefulWidget {
  @override
  _CommonSearchListState createState() => _CommonSearchListState();
}

class _CommonSearchListState extends State<CommonSearchList> {

  @override
  void initState() {
    super.initState();
    initThemeConfig();
  }

  String theme = '';
  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: const Color(0xFFefeff4),
      appBar: AppBar(
        title: SuperTextField(
          deleteIcon: Icon(
            Icons.cancel,
            color: Colors.white.withOpacity(0.5),
          ),
          keyboardType: SuperTextInputType.text,
          hintText: '输入装备名称进行搜索',
          hintStyle: const TextStyle(color: Colors.white),
          textStyle: const TextStyle(color: Colors.white),
          onChanged: (value) {
            //实时搜索
          },
          inputBorder: InputBorder.none,
          cursorColor: Colors.white,
          autofocus: true,
        ),
        leading: LeadingButton(
          theme: theme,
        ),
      ),
      body: buildCommonSearchListContent(context),
    );
  }

  Widget buildCommonSearchListContent(context) {
    return ListView.builder(
        padding: EdgeInsets.symmetric(horizontal: 10.px, vertical: 5.px),
        itemCount: 10,
        itemBuilder: (ctx, index) {
          return CommonCardItem(
            theme: theme,
            title: '全盔式消防头盔',
            count: '345',
            image: Image.asset(
              'assets/images/equip_cap.png',
              package: ExternalAssetsPackageKey.BASE,
              width: 70.px,
            ),
            onPress: (value) {
              Application.navigateTo(context, Routes.commonSingleEquipmentList);
            },
          );
        });
  }
}
