import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:base/consts/route_category_front_component_const.dart';

import 'package:base/model/route_model.dart';
import 'package:base/services/application.dart';
import 'package:base/utils/request.dart';
import 'package:chewie/chewie.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg_provider/flutter_svg_provider.dart';
import 'package:provider/provider.dart';
import 'package:video_player/video_player.dart';

import '../model/car_detail_model.dart';
import '../model/car_detail_view_model.dart';
import '../model/equipment_info_model.dart';
import '../routes/routes.dart';

class EquipmentCarExtinguishDetailBaseInfo extends StatefulWidget {
  final RouteModel routeModel;
  const EquipmentCarExtinguishDetailBaseInfo(this.routeModel);

  @override
  _EquipmentCarExtinguishDetailBaseInfoState createState() =>
      _EquipmentCarExtinguishDetailBaseInfoState();
}

class _EquipmentCarExtinguishDetailBaseInfoState
    extends State<EquipmentCarExtinguishDetailBaseInfo> {
  @override
  void initState() {
    super.initState();

    String carId = widget.routeModel.extension['carId'];

    HttpRequest.getCarDetail(carId).then((res) {
      if (res['status'] == 200) {
        CarDetailModel model = CarDetailModel.fromJson(res['result']);
        Provider.of<CarDetailViewModel>(context, listen: false).carModel =
            model;
      }
    }).catchError((err) {});
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<CarDetailViewModel>(
      builder: (ctx, carDetailVm, child) {
        if (carDetailVm.carModel == null) {
          return const Center(
            child: CupertinoActivityIndicator(),
          );
        } else {
          return child;
        }
      },
      child: ListView(
        shrinkWrap: true,
        padding: EdgeInsets.symmetric(horizontal: 8.px, vertical: 8.px),
        children: <Widget>[
          buildCard1(context),
          SizedBox(
            height: 3.px,
          ),
          buildCard2(context),
          SizedBox(
            height: 3.px,
          ),
          buildCard3(context),
        ],
      ),
    );
  }

  Widget getBaseInfoList1(RouteModel routeModel) {
    String category = routeModel.category;
    if (category == RouteCategoryFrontComponentConst.equipment) {
      return EquipInfoList1();
    } else if (category ==
        RouteCategoryFrontComponentConst.fireFightingVehicle) {
      return CarInfoList1();
    } else {
      return ExtinguishedInfoList1();
    }
  }

  Widget getBaseInfoList2(RouteModel routeModel) {
    String category = routeModel.category;
    if (category == RouteCategoryFrontComponentConst.equipment) {
      return EquipInfoList2();
    } else if (category ==
        RouteCategoryFrontComponentConst.fireFightingVehicle) {
      return CarInfoList2();
    } else {
      return ExtinguishedInfoList2();
    }
  }

  Widget buildCard1(BuildContext context) {
    return Card(
      shadowColor: const Color.fromRGBO(69, 91, 99, 0.08),
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8.px)),
      elevation: 8,
      child: VideoBaseContentCard(widget.routeModel),
    );
  }

  Widget buildCard2(BuildContext context) {
    return Card(
      shadowColor: const Color.fromRGBO(69, 91, 99, 0.08),
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8.px)),
      elevation: 8,
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: 16.px, vertical: 14.px),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Text(
              widget.routeModel.category ==
                      RouteCategoryFrontComponentConst.fireFightingVehicle
                  ? '车辆信息'
                  : '装备信息',
              style: Theme.of(context).textTheme.headline4,
            ),
            getBaseInfoList1(widget.routeModel)
          ],
        ),
      ),
    );
  }

  Widget buildCard3(BuildContext context) {
    return Card(
      shadowColor: const Color.fromRGBO(69, 91, 99, 0.08),
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8.px)),
      elevation: 8,
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: 16.px, vertical: 14.px),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Text(
              '基本信息',
              style: Theme.of(context).textTheme.headline4,
            ),
            getBaseInfoList2(widget.routeModel)
          ],
        ),
      ),
    );
  }
}

class VideoBaseContentCard extends StatefulWidget {
  final RouteModel routeModel;
  const VideoBaseContentCard(this.routeModel);

  @override
  _VideoBaseContentCardState createState() => _VideoBaseContentCardState();
}

class _VideoBaseContentCardState extends State<VideoBaseContentCard>
    with AutomaticKeepAliveClientMixin {
  VideoPlayerController _videoPlayerController;
  ChewieController _chewieController;

  // 装备信息model
  EquipmentInfoModel _equipmentInfoModel;

  Widget getBaseInfoList(RouteModel routeModel) {
    String category = routeModel.category;
    if (category == RouteCategoryFrontComponentConst.equipment) {
      return EquipBaseInfo(
        model: _equipmentInfoModel,
      );
    } else if (category ==
        RouteCategoryFrontComponentConst.fireFightingVehicle) {
      return CarBaseInfo();
    } else {
      return ExtinguishedBaseInfo();
    }
  }

  @override
  void initState() {
    super.initState();
  }

  @override
  void dispose() {
    if (_equipmentInfoModel.film != null) {
      _videoPlayerController.dispose();
      _chewieController.dispose();
    }
    super.dispose();
  }

  // 构建基本信息
  // 车辆有额外的 装载器材 电子履历 生产企业
  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        _equipmentInfoModel.film != null
            ? Chewie(
                controller: _chewieController,
              )
            : Container(
                width: double.infinity,
                height: 200,
                color: Colors.red,
              ),
        getBaseInfoList(widget.routeModel)
      ],
    );
  }

  @override
  bool get wantKeepAlive => true;
}

// 器材装备基本信息
class EquipBaseInfo extends StatelessWidget {
  final EquipmentInfoModel model;
  const EquipBaseInfo({this.model});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 23.px, vertical: 10.px),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Text(
            '${model.equipName}',
            style:
                Theme.of(context).textTheme.headline3.copyWith(fontSize: 18.px),
          ),
          SizedBox(
            height: 5.px,
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: <Widget>[
              Text('库存: ${model.count}${model.unit}',
                  style: Theme.of(context)
                      .textTheme
                      .subtitle2
                      .copyWith(fontSize: 14.px)),
              Row(
                children: <Widget>[
                  const Image(
                    image: Svg('assets/images/icon_equip_qr.svg',
                        size: Size(12, 12)),
                  ),
                  SizedBox(
                    width: 5.px,
                  ),
                  Text(
                    '${model.qrCode}',
                    style: Theme.of(context)
                        .textTheme
                        .headline4
                        .copyWith(fontSize: 12.px),
                  )
                ],
              )
            ],
          ),
        ],
      ),
    );
  }
}

// 车辆基本信息
class CarBaseInfo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 23.px, vertical: 15.px),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: <Widget>[
              Text(
                '消防特种呼吸器',
                style: Theme.of(context)
                    .textTheme
                    .headline3
                    .copyWith(fontSize: 18.px),
              ),
              Row(
                children: <Widget>[
                  const Image(
                    image: Svg('assets/images/icon_equip_qr.svg',
                        size: Size(12, 12)),
                  ),
                  SizedBox(
                    width: 5.px,
                  ),
                  Text(
                    '739709375585091',
                    style: Theme.of(context)
                        .textTheme
                        .headline4
                        .copyWith(fontSize: 12.px),
                  )
                ],
              )
            ],
          ),
          SizedBox(
            height: 10.px,
          ),
          InkWell(
            onTap: () => vehicleLoaded(context),
            child: Padding(
              padding: EdgeInsets.symmetric(vertical: 10.px),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text(
                    '装载器材',
                    style: Theme.of(context).textTheme.headline6,
                  ),
                  const Icon(Icons.keyboard_arrow_right)
                ],
              ),
            ),
          ),
          InkWell(
            onTap: () => vehicleResumeTap(context),
            child: Padding(
              padding: EdgeInsets.symmetric(vertical: 10.px),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text(
                    '电子履历',
                    style: Theme.of(context).textTheme.subtitle1,
                  ),
                  const Icon(Icons.keyboard_arrow_right)
                ],
              ),
            ),
          ),
          InkWell(
            onTap: () => manufactureTap(context),
            child: Padding(
              padding: EdgeInsets.symmetric(vertical: 10.px),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text(
                    '生产企业',
                    style: Theme.of(context).textTheme.subtitle1,
                  ),
                  const Icon(Icons.keyboard_arrow_right)
                ],
              ),
            ),
          )
        ],
      ),
    );
  }

  void vehicleLoaded(BuildContext context) {
    Application.navigateTo(context, Routes.vehicleLoaded);
  }

  void vehicleResumeTap(BuildContext context) {
    Application.navigateTo(context, Routes.vehicleResume);
  }

  void manufactureTap(BuildContext context) {
    Application.navigateTo(context, Routes.vehicleManufacturingEnterprise);
  }
}

// 灭火药剂基本信息
class ExtinguishedBaseInfo extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 23.px, vertical: 10.px),
      child: Row(
        children: <Widget>[
          Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              Text(
                '消防特种呼吸器',
                style: Theme.of(context)
                    .textTheme
                    .headline3
                    .copyWith(fontSize: 18.px),
              ),
              SizedBox(
                height: 5.px,
              ),
              Text('库存总量: 0.1吨',
                  style: Theme.of(context)
                      .textTheme
                      .subtitle2
                      .copyWith(fontSize: 14.px)),
              SizedBox(
                height: 5.px,
              ),
              Text('批次号 2017-11-01',
                  style: Theme.of(context)
                      .textTheme
                      .subtitle2
                      .copyWith(fontSize: 14.px)),
              SizedBox(
                height: 5.px,
              ),
              Text('当前批次数量: 0.1吨',
                  style: Theme.of(context)
                      .textTheme
                      .subtitle2
                      .copyWith(fontSize: 14.px)),
            ],
          ),
        ],
      ),
    );
  }
}

// 器材信息列表1
class EquipInfoList1 extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('所属单位:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('仓库:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('货位:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('装备分类:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('装备编码:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('合同编号:', style: Theme.of(context).textTheme.bodyText2),
        ),
      ],
    );
  }
}

// 车辆信息列表1
class CarInfoList1 extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('所属机构:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('装备编码:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('车辆类别:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('车辆名称:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('国别:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('整车生产厂家:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('车架号码:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('发动机型号:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('底盘品牌:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('出厂日期:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('底盘类别:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('商标:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('参考价:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('车辆等级:', style: Theme.of(context).textTheme.bodyText2),
        )
      ],
    );
  }
}

// 灭火药剂信息列表1
class ExtinguishedInfoList1 extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('仓库:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('整备分类:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('整备编码:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('合同编号:', style: Theme.of(context).textTheme.bodyText2),
        )
      ],
    );
  }
}

// 器材信息列表2
class EquipInfoList2 extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('规格型号:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('保养周期:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('供应商:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('生产厂商:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('品牌:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('生产日期:', style: Theme.of(context).textTheme.bodyText2),
        )
      ],
    );
  }
}

// 车辆信息列表2
class CarInfoList2 extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('长度:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('宽度:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('高度:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('总质量:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('底盘型号:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('核载人数:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('燃油种类:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('润滑脂种类:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('发动机号:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child:
              Text('3C认证报告证书:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('驾驶方式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('取力器形式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('发动机冷却方式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('其他工作能力:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('是否有红外功能:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('车辆接近角:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('固定座位数:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('润滑油种类:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('油耗标准:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('发送机功率:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('灭火方式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('机翼形式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('变速箱类型:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('吨位:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child:
              Text('是否带有摄录像设备:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('其他特殊功能:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('满载质量:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('车辆离去角:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('油箱容量:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('液压油种类:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('发动机类别:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('检测批号:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('驱动形式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('摩托车形式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('主要工作能力:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('轮式履带式:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('维修保养说明:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('简介:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('备注:', style: Theme.of(context).textTheme.bodyText2),
        ),
      ],
    );
  }
}

// 灭火药剂信息列表2
class ExtinguishedInfoList2 extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('规格型号:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('代理商:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('生产厂商:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('品牌:', style: Theme.of(context).textTheme.bodyText2),
        ),
        Padding(
          padding: EdgeInsets.only(top: 23.px),
          child: Text('生产日期:', style: Theme.of(context).textTheme.bodyText2),
        )
      ],
    );
  }
}
