import 'package:base/consts/color.dart';
import 'package:flutter/material.dart';

import 'package:shared_preferences/shared_preferences.dart';

import 'package:base/widgets/back_button.dart';

GlobalKey<_VehicleLoadedContentState> childKey = GlobalKey();

class VehicleManufacturingEnterprise extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(
          "生产企业",
          style: Theme.of(context).textTheme.headline2,
        ),
        centerTitle: true,
        leading: LeadingButton(
          theme: childKey.currentState.theme,
        ),
      ),
      body: VehicleManufacturingEnterpriseContent(),
    );
  }
}

class VehicleManufacturingEnterpriseContent extends StatefulWidget {
  @override
  _VehicleLoadedContentState createState() => _VehicleLoadedContentState();
}

class _VehicleLoadedContentState
    extends State<VehicleManufacturingEnterpriseContent> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }

  String theme = '';
  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Container();
  }
}
