import 'dart:convert' show json;

import 'package:dio/dio.dart';
import 'package:base/model/APIResponse.dart';
import 'package:safe_control/model/CheckExecute/check_point_record_list.dart';
import 'package:safe_control/model/CheckExecute/query_point_detail.dart';
import 'package:safe_control/model/CheckRecordDto.dart';
import 'package:safe_control/model/MovePointAttachment.dart';
import 'package:safe_control/model/plan_list_input.dart';
import 'package:base/services/api_address.dart';
import 'package:base/utils/HttpUtil.dart';

Future<APIResponse> saveCheckRecord(CheckRecordDto dto) async {
  try {
    if (null == dto) {
      return APIResponse.error("必填参数不能为空！");
    }
    var data = await HttpUtil()
        .post(ApiAddress.SAVE_CHECK_RECORD, data: dto.toString());
    return APIResponse(data);
  } catch (e) {
    return APIResponse.error("保存失败！");
  }
}

Future<APIResponse> uploadAttachFile(
    List<Attachment> fileList, int checkId, int pointId) async {
  try {
    if (null == fileList || null == checkId || null == pointId) {
      return APIResponse.error("必填参数不能为空！");
    }
    // 循环上传
    fileList.forEach((attach) {
      var uploadUrl = ApiAddress.UPLOAD_CHECK_FILE +
          "?checkId=" +
          checkId.toString() +
          "&pointId=" +
          pointId.toString();
      // 如果有ItemId
      if (null != attach.itemId) {
        // 检查项的图片
        uploadUrl +=
            "&inputItemId=" + attach.itemId.toString() + "&name=" + attach.name;
      }
      String filename =
          attach.file.path.substring(attach.file.path.lastIndexOf("/") + 1);
      // 开始上传
      FormData formData = new FormData.fromMap({
        "file": MultipartFile.fromFile(attach.file.path.toString(),
            filename: filename)
      });
      var data = HttpUtil().post(uploadUrl, data: formData);
    });
    return APIResponse.success("保存成功！");
  } catch (e) {
    return APIResponse.error("保存失败！");
  }
}

// 移动巡检--记录--巡检点名称
Future<Map<String, List<CheckPointRecordDetail>>> getCheckPointRecordList(
    PlanListInput planListInput, num pointId) async {
  try {
//    List<PlanListOutput> planListOutputList = new List();
    // 根据输入参数拼接请求body
    List<Map> request = new List();

    // 用户ID
    if (null != planListInput.userId && -1 != planListInput.userId) {
      request.add({"name": "userId", "value": planListInput.userId});
    }

    // 状态
    if (null != planListInput.finishStatus &&
        -1 != planListInput.finishStatus) {
//      request.add({"name": "finishStatus", "value" :planListInput.finishStatus});
      request.add({"name": "isOk", "value": planListInput.finishStatus});
    }

    // 开始时间
    if (null != planListInput.startTime && "" != planListInput.startTime) {
      request.add({
        "name": "startTime",
        "value": planListInput.startTime + " 00:00:00"
      });
    }

    // 结束时间
    if (null != planListInput.endTime && "" != planListInput.endTime) {
      request.add(
          {"name": "endTime", "value": planListInput.endTime + " 23:59:59"});
    }

    // 部门
    if (null != planListInput.departmentId &&
        -1 != planListInput.departmentId) {
      request
          .add({"name": "departmentId", "value": planListInput.departmentId});
    }

    // 线路
    if (null != planListInput.routeId && -1 != planListInput.routeId) {
      request.add({"name": "routeId", "value": planListInput.routeId});
    }

    request.add({"name": "pointId", "value": pointId});

//    print(json.encode(request));

    Map<String, List<CheckPointRecordDetail>> rst = Map();

    // 调用接口查询数据
    var data = await HttpUtil()
        .post(ApiAddress.CHECK_POINT_RECORD_LIST, data: json.encode(request));
    //具体实现函数待编写
    if (data["result"] == "SUCCESS") {
      if (data["dataList"].toString() != "[]") {
//        print(data["dataList"]);
        Map<String, dynamic> _data = data["dataList"];
        _data.forEach((k, v) {
          List<CheckPointRecordDetail> detailLst = List();
          for (var _detail in v) {
            detailLst.add(CheckPointRecordDetail.fromJson(_detail));
          }
          rst[k] = detailLst;
        });
      }
    }
    return rst;
  } catch (e) {
    throw e;
  }
}

// 巡检点详情
Future<QueryPointDetail> getQueryPointDetail(num pointId) async {
  QueryPointDetail detail = QueryPointDetail();

//  var dataRst = await HttpUtil().get(ApiAddress.QUERY_POINT_DETAIL_BY_ID,data: {"pointId":pointId});
  var dataRst = await HttpUtil()
      .get(ApiAddress.QUERY_POINT_DETAIL_BY_ID_v2, data: {"pointId": pointId});

  if (dataRst["result"] == "SUCCESS") {
    if (dataRst["dataList"].toString() != "[]") {
      var data = dataRst["dataList"];
      PointInfo pointInfo = PointInfo.fromJson(data["point"]);
      List<InputItems> inputItems = List();
      for (var inputitem in data["inputItems"]) {
        inputItems.add(InputItems.fromJson(inputitem));
      }
      List<Classify> classifies = List();
      for (var classify in data["classify"]) {
        classifies.add(Classify.fromJson(classify));
      }
      List<Route> routs = List();
      for (var route in data["routes"]) {
        routs.add(Route.fromJson(route));
      }

      detail.pointInfo = pointInfo;
      // TODO:融合未对应
//      detail.inputItems = inputItems;
      detail.classifies = classifies;
      detail.routs = routs;
    }
  }
  return detail;
}
