import 'package:base/services/api_address.dart';
import 'package:base/utils/HttpUtil.dart';

import '../model/name_value.dart';

//获取全部任务列表
Future<List<NameValue>> getRouteList() async {
  try {
    // 根据输入参数拼接请求body
    List<Map> request = [];
    List<NameValue> result = [];
    var data = await HttpUtil().get(ApiAddress.ROUTE_LIST);
    //具体实现函数待编写
    if (data['result'] == 'SUCCESS') {
      var dataList = data['dataList'];
      for (final _dataList in dataList) {
        result.add(NameValue(_dataList['name'], _dataList['id']));
      }
    }
    return result;
  } catch (e) {
    rethrow;
  }
}
