import 'package:base/consts/color.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/name_value.dart';
import '../../services/plan_list_services.dart';

class SelectPlanPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => _SelectPlanPageState();
}

class _SelectPlanPageState extends State<SelectPlanPage> {
  final TextEditingController _controller = TextEditingController();
  FocusNode _focusNode = FocusNode();
  List<NameValue> planList = List();
  List<NameValue> tmpPlanList = List();
  String theme = "";

  @override
  void initState() {
    super.initState();
    getInitInfo();
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme = preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        elevation: 0.3,
        brightness: Brightness.light,
        title: Container(
          height: 30,
          width: MediaQuery.of(context).size.width - 130,
          padding: EdgeInsets.only(bottom: 5),
          decoration: BoxDecoration(
            color: Colors.grey[100],
            borderRadius: BorderRadius.all(Radius.circular(25.0)),
          ),
          child: Row(
            children: <Widget>[
              Container(
                padding: EdgeInsets.only(left: 5, right: 5, top: 6),
                child: Icon(
                  Icons.search,
                  color: Theme.of(context).primaryColor,
                ),
              ),
              Container(
                width: MediaQuery.of(context).size.width - 180,
                child: TextField(
                    controller: _controller,
                    focusNode: _focusNode,
                    style: TextStyle(fontSize: 16.0, color: Colors.black),
                    decoration: InputDecoration(border: InputBorder.none, contentPadding: EdgeInsets.only(top: -15))),
              )
            ],
          ),
        ),

        actions: <Widget>[
          Align(
              child: Padding(
            padding: EdgeInsets.only(right: 8),
            child: GestureDetector(
              onTap: () {
                setState(() {
                  if (this._controller.text.isEmpty) {
                    this.planList = tmpPlanList;
                  } else {
                    this.planList = tmpPlanList.where((f) => f.name.indexOf(this._controller.text) != -1).toList();
                  }
                });
              },
              child: Text(
                "搜索",
              ),
            ),
          ))
        ],
      ),
      body: ListView.builder(
        itemCount: planList.length,
        itemBuilder: (context, index) {
          return ListTile(
            title: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text('${planList[index].name}'),
                Divider(
                  height: 1,
                )
              ],
            ),
            onTap: () {
              Navigator.pop(context, NameValue(planList[index].name, planList[index].value));
            },
          );
        },
      ),
    );
  }

  void getInitInfo() async {
    // 获取线路数据
    await getPlanList().then((data) {
      setState(() {
        planList = data;
        tmpPlanList = data;
      });
    });
  }
}
