import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:flutter/material.dart';

import '../no_plan_inspection/manual_input.dart';
import '../no_plan_inspection/nfc_page.dart';
import 'qr_page_new.dart';

class NoPlanInspection extends StatefulWidget {
  final num taskId;

  const NoPlanInspection({this.taskId});

  @override
  State<StatefulWidget> createState() => _NoPlanInspectionState();
}

class _NoPlanInspectionState extends State<NoPlanInspection> with SingleTickerProviderStateMixin {
  TabController _tabController;
  int _selectedIndex = 0;
  var titles = ['NFC', '二维码', '输入'];
  bool activeScan = false;

  @override
  void initState() {
    super.initState();
    _tabController = TabController(vsync: this, initialIndex: 0, length: titles.length);
    _tabController.addListener(() {
      if (_tabController.index == 1) {
        activeScan = true;
      } else {
        activeScan = false;
      }
      setState(() => _selectedIndex = _tabController.index);
    });
    print(widget.taskId);
  }

  void setSelectFirstIndex() {
    setState(() {
      _selectedIndex = 0;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      bottomNavigationBar: Container(
        height: 118.01,
        child: Column(
          children: <Widget>[
            TabBar(
              isScrollable: false,
              controller: _tabController,
              indicatorColor: Colors.black87,
              labelColor: Colors.white,
              labelPadding: const EdgeInsets.all(0),
              indicatorWeight: 0.01,
              tabs: <Widget>[
                EachTab(
                  width: 130,
                  height: 118,
                  padding: const EdgeInsets.all(0),
                  icon: _selectedIndex == 0
                      ? Image.asset(
                          'assets/images/noplan/no_plan_nfc.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 80,
                          height: 40,
                        )
                      : Image.asset(
                          'assets/images/noplan/no_plan_nfc.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 80,
                          height: 40,
                        ),
                  text: titles[0],
                  iconPadding: const EdgeInsets.fromLTRB(0, 0, 0, 10),
                  textStyle: const TextStyle(fontSize: 16, color: Colors.white),
                  color: _selectedIndex == 0 ? Colors.black87 : Colors.black54,
                ),
                EachTab(
                  width: 130,
                  height: 118,
                  padding: const EdgeInsets.all(0),
                  icon: _selectedIndex == 1
                      ? Image.asset(
                          'assets/images/noplan/no_plan_qr.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 80,
                          height: 40,
                        )
                      : Image.asset(
                          'assets/images/noplan/no_plan_qr.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 80,
                          height: 40,
                        ),
                  text: titles[1],
                  iconPadding: const EdgeInsets.fromLTRB(0, 0, 0, 10),
                  textStyle: const TextStyle(fontSize: 16, color: Colors.white),
                  color: _selectedIndex == 1 ? Colors.black87 : Colors.black54,
                ),
                EachTab(
                  width: 130,
                  height: 118,
                  padding: const EdgeInsets.all(0),
                  icon: _selectedIndex == 2
                      ? Image.asset(
                          'assets/images/noplan/no_plan_input.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 80,
                          height: 40,
                        )
                      : Image.asset(
                          'assets/images/noplan/no_plan_input.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 80,
                          height: 40,
                        ),
                  text: titles[2],
                  iconPadding: const EdgeInsets.fromLTRB(0, 0, 0, 10),
                  textStyle: const TextStyle(fontSize: 16, color: Colors.white),
                  color: _selectedIndex == 2 ? Colors.black87 : Colors.black54,
                ),
              ],
            )
          ],
        ),
      ),
      body: TabBarView(
        physics: const NeverScrollableScrollPhysics(), //设置滑动的效果，这个禁用滑动
        controller: _tabController,
        children: <Widget>[
          widget.taskId != null && widget.taskId > 0
              ? NfcPage(
                  taskId: widget.taskId,
                )
              : const NfcPage(),
          NewQrPage(
            activeScan: activeScan,
          ),
          widget.taskId != null && widget.taskId > 0
              ? ManualInput(
                  taskId: widget.taskId,
                )
              : const ManualInput(),
        ],
      ),
    );
  }
}
