import 'package:flutter/material.dart';

class KColorConstant {
  static const Color themeColor = Color.fromRGBO(132, 95, 63, 1.0);
  static const Color floorTitleColor = Color.fromRGBO(51, 51, 51, 1);
  static const Color searchBarBgColor = Color.fromRGBO(240, 240, 240, 1.0);
  static const Color searchBarTxtColor = Color(0xFFCDCDCD);
  static const Color divideLineColor = Color.fromRGBO(245, 245, 245, 1.0);
  static const Color categoryDefaultColor = Color(0xFF666666);
  static const Color priceColor = Color.fromRGBO(182, 9, 9, 1.0);
  static const Color pinweicorverSubtitleColor = Color.fromRGBO(153, 153, 153, 1.0);
  static const Color pinweicorverBtbgColor = themeColor;
  static const Color pinweicorverBtTxtColor = Color(0xFFFFFFFF);
  static const Color tabtxtColor = Color.fromRGBO(88, 88, 88, 1.0);
  static const Color cartDisableColor = Color.fromRGBO(221, 221, 221, 1.0);
  static const Color cartItemChangenumBtColor = Color.fromRGBO(153, 153, 153, 1.0);
  static const Color cartItemCountTxtColor = Color.fromRGBO(102, 102, 102, 1.0);
  static const Color cartBottomBgColor = Color(0xFFFFFFFF);
  static const Color goPayBtBgColor = themeColor;
  static const Color goPayBtTxtColor = Color(0xFFFFFFFF);
  static const Color searchAppBarBgColor = Color(0xFFFFFFFF);
  static const Color bottomBarbgColor = Color.fromRGBO(250, 250, 250, 1.0);
  static const Color searchRecomendDividerColor = Color(0xFFdedede);
  static const String DEFAULT_COLOR = 'blue';
  static const Color topBarColor = Color(0xFFFFFFFF);
}

class AMOSColors {
  ///故障报修状态
  static const Color waitAudit = Colors.grey; //待审核
  static const Color waitSubmit = Color(0xFFA2C914); //待提交
  static const Color waitRepair = Colors.orange; //待维修
  static const Color repairing = Colors.blue; //维修中
  static const Color waitVerify = Colors.purple; //待验收
  static const Color finished = Colors.green; //已完结
  static const Color rejected = Colors.red; //已拒绝

  ///故障报修状态颜色
  static Color malfunctionStatusColor(String status) {
    switch (status) {
      case '待审核':
        return waitAudit;
        break;
      case '待提交':
        return waitSubmit;
        break;
      case '待维修':
        return waitRepair;
        break;
      case '维修中':
        return repairing;
        break;
      case '待验收':
        return waitVerify;
        break;
      case '已完结':
        return finished;
        break;
      case '已拒绝':
        return rejected;
        break;
      default:
        return Colors.grey;
        break;
    }
  }

  ///消防维保计划状态
  static Color maintenancePlanStatusColor(int status) {
    switch (status) {
      case 0:
        return Colors.grey; //未开始
        break;
      case 1:
        return Colors.orange; //待执行
        break;
      case 2:
        return Colors.green; //已结束
        break;
      case 3:
        return Colors.red; //已超时
        break;
      default:
        return Colors.grey;
        break;
    }
  }

  ///消防维保设施状态
  static Color maintenanceEquipmentStatusColor(int status) {
    switch (status) {
      case 0:
        return Colors.orange; //未完成
        break;
      case 1:
        return Colors.green; //已完成
        break;
      case 2:
        return Colors.red; //超时未维保
        break;
      default:
        return Colors.grey;
        break;
    }
  }

  ///消防维保设施记录状态
  static Color maintenanceEquipmentRecordStatusColor(String status) {
    switch (status) {
      case '正常':
        return Colors.lightBlue; //正常
        break;
      case '已到期':
        return Colors.orange; //已到期
        break;
      default:
        return Colors.grey;
        break;
    }
  }

  ///消防维保记录状态
  static Color maintenanceRecordStatusColor(int status) {
    switch (status) {
      case 1:
        return Colors.green; //合格
        break;
      case 2:
        return Colors.red; //不合格
        break;
      case 3:
        return Colors.orange; //漏检
        break;
      default:
        return Colors.grey;
        break;
    }
  }

  ///消防维保记录状态
  static Color fireproofSupervisionPointStatusColor(int status) {
    switch (status) {
      case 0:
        return Colors.grey; //未开始
        break;
      case 1:
        return Colors.orange; //执行中
        break;
      case 2:
        return Colors.green; //已完成
        break;
      case 3:
        return Colors.red; //超时漏检
        break;
      default:
        return Colors.grey;
        break;
    }
  }
}
