import 'package:flutter/material.dart';
import 'package:timelines/timelines.dart';

import 'TimeLineData.dart';

///时间轴居中，两边都有文字
class TimeLineCenter extends StatelessWidget {
  List<TimeLineData> data;

  TimeLineCenter(this.data);

  @override
  Widget build(BuildContext context) {
    return Timeline.tileBuilder(
      shrinkWrap: true,
      theme: TimelineThemeData(
        nodePosition: 0.3,
        connectorTheme: const ConnectorThemeData(),
        indicatorTheme: const IndicatorThemeData(),
      ),
      builder: TimelineTileBuilder.connected(
        connectionDirection: ConnectionDirection.after,
        //左边内容
        oppositeContentsBuilder: (context, index) => Padding(
          padding: const EdgeInsets.all(10.0),
          child: Text(data[index].leftText),
        ),
        //右边内容
        contentsBuilder: (context, index) => Padding(
          padding: const EdgeInsets.all(10.0),
          child: Text(data[index].rightText),
        ),
        //连接线
        connectorBuilder: (context, index, type) => SizedBox(
          height: data[index].height,
          child: const SolidLineConnector(
            color: Colors.grey,
            thickness: 1,
          ),
        ),
        //连接点
        indicatorBuilder: (context, index) => OutlinedDotIndicator(
          color: data[index].indicatorColor,
          size: 11,
        ),
        itemCount: data.length,
      ),
    );
  }
}
