import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';
import 'package:flutter_treeview/tree_view.dart';
import 'package:get/get.dart' hide Node;

///@Description     树形选择控件
///@author          helinlin
///@create          2021-11-02 11:17
abstract class ChooseTreeState<T extends StatefulWidget> extends State<T> {
  List<Node> tree = <Node>[];
  TreeViewController _treeViewController;
  String selectKey = '';

  @override
  void initState() {
    super.initState();
    _treeViewController = TreeViewController(children: tree);
    _initData();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('请选择'),
      ),
      body: Column(
        children: [
          Expanded(
            child: TreeView(
              controller: _treeViewController,
              theme: const TreeViewTheme(),
              allowParentSelect: true,
              supportParentDoubleTap: false,
              onExpansionChanged: (String key, bool state) {},
              onNodeTap: (key) {
                setState(() {
                  selectKey = key;
                });
              },
              nodeBuilder: (BuildContext context, Node node) {
                return Padding(
                  padding: const EdgeInsets.symmetric(vertical: 5),
                  child: Row(
                    children: [
                      const Icon(
                        Icons.folder,
                        color: Colors.blue,
                      ),
                      Expanded(
                        child: Text(
                          node.label,
                          style: TextStyle(color: selectKey == node.key ? Colors.blue : Colors.black),
                        ),
                      ),
                      selectKey == node.key
                          ? const Padding(
                              padding: EdgeInsets.only(right: 8),
                              child: Icon(
                                Icons.check,
                                color: Colors.blue,
                                size: 18,
                              ),
                            )
                          : Container()
                    ],
                  ),
                );
              },
            ),
          ),
          Row(
            children: [
              Expanded(
                child: Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: FlatButton(
                    onPressed: () {
                      Get.back(result: _treeViewController.getNode(selectKey).data);
                    },
                    child: const Text(
                      '确定',
                      style: TextStyle(color: Colors.white),
                    ),
                    color: Theme.of(context).primaryColor,
                  ),
                ),
              ),
            ],
          )
        ],
      ),
    );
  }

  Future<void> _initData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后。。。');
      var data = await getData();
      if (data != null) {
        setState(() {
          tree.addAll(buildNode(data));
        });
      }
    }).whenComplete(() => Get.back());
  }

  List<Node> buildNode(dynamic data) {
    List<Node> nodes = <Node>[];
    if (data != null && data.isNotEmpty) {
      data.forEach((item) {
        nodes.add(Node(
            label: item[getName()] ?? '全部建筑', key: item[getKey()] ?? 'all', children: buildNode(item['children']), data: item));
      });
    }
    return nodes;
  }

  Future getData();

  String getKey();

  String getName();
}
