import 'package:flutter/material.dart';

/// 查询组件
class SearchWidget extends StatefulWidget {
  final double height; // 高度
  final double width; // 宽度
  final String hintText; // 输入提示
  final ValueChanged<String> onEditingComplete; // 编辑完成的事件回调

  const SearchWidget(
      {Key key,
        this.height,
        this.width,
        this.hintText,
        this.onEditingComplete})
      : super(key: key);

  @override
  State<SearchWidget> createState() => _SearchWidgetState();
}

class _SearchWidgetState extends State<SearchWidget> {
  var controller = TextEditingController();

  @override
  void initState() {
    super.initState();
  }

  /// 清除查询关键词
  clearKeywords() {
    controller.text = "";
  }

  @override
  Widget build(BuildContext context) {
    double height = 42;
    return Container(
      height: height,
      // color: Colors.white,
      margin: EdgeInsets.fromLTRB(10.0, 13.0, 13.0, 13.0),
      decoration: BoxDecoration(
          border: Border.all(color: Colors.black26),
          color: Colors.white,
          borderRadius: BorderRadius.circular(12)),
          padding: const EdgeInsets.symmetric(horizontal: 8),
      //padding: EdgeInsets.fromLTRB(10.px, 13.px, 24.px, 13.px),
      child: TextField(
          controller: controller,
          decoration: InputDecoration(
              hintText: widget.hintText ?? "请输入搜索词",
              hintStyle: TextStyle(color: Colors.grey, fontSize: 14),
              border: InputBorder.none,
              icon:Icon(
                Icons.search,
                color: Colors.grey,
              ),
              suffixIcon: IconButton(
                icon: const Icon(
                  Icons.close,
                  size: 17,
                ),
                onPressed: clearKeywords,
                splashColor: Theme.of(context).primaryColor,
              )),
          onChanged: widget.onEditingComplete,

          ),
    );
  }
}


