class HomeConfigModel {
  HomeConfigModel({
    this.title,
    this.type,
    this.data,
  });

  String title;
  int type;
  List<Datum> data;

  factory HomeConfigModel.fromJson(Map<String, dynamic> json) =>
      HomeConfigModel(
        title: json["title"],
        type: json["type"],
        data: List<Datum>.from(json["data"].map((x) => Datum.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "title": title,
        "type": type,
        "data": List<dynamic>.from(data.map((x) => x.toJson())),
      };
}

class Datum {
  Datum({
    this.title,
    this.img,
    this.path,
    this.permissionCode,
  });

  String title;
  String img;
  String path;
  String permissionCode;

  factory Datum.fromJson(Map<String, dynamic> json) => Datum(
        title: json["title"],
        img: json["img"],
        path: json["path"],
        permissionCode: json["permissionCode"],
      );

  Map<String, dynamic> toJson() => {
        "title": title,
        "img": img,
        "path": path,
        "permissionCode": permissionCode,
      };
}
