class WarehouseInfoModel {
  WarehouseInfoModel({
    this.warehouse,
    this.dictionaries,
  });

  Warehouse warehouse;
  String dictionaries;

  factory WarehouseInfoModel.fromJson(Map<String, dynamic> json) =>
      WarehouseInfoModel(
        warehouse: Warehouse.fromJson(json['warehouse']),
        dictionaries: json['dictionaries'],
      );

  Map<String, dynamic> toJson() => {
        'warehouse': warehouse.toJson(),
        'dictionaries': dictionaries,
      };
}

class Warehouse {
  Warehouse({
    this.id,
    this.createDate,
    this.name,
    this.telephone,
    this.dutyTelephone,
    this.remark,
    this.level,
    this.owner,
    this.userId,
    this.userName,
    this.orgCode,
    this.companyName,
  });

  String id;
  DateTime createDate;
  String name;
  String telephone;
  String dutyTelephone;
  String remark;
  dynamic level;
  dynamic owner;
  String userId;
  dynamic userName;
  String orgCode;
  dynamic companyName;

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        id: json['id'],
        createDate: DateTime.parse(json['createDate']),
        name: json['name'],
        telephone: json['telephone'],
        dutyTelephone: json['dutyTelephone'],
        remark: json['remark'],
        level: json['level'],
        owner: json['owner'],
        userId: json['userId'],
        userName: json['userName'],
        orgCode: json['orgCode'],
        companyName: json['companyName'],
      );

  Map<String, dynamic> toJson() => {
        'id': id,
        'createDate': createDate.toIso8601String(),
        'name': name,
        'telephone': telephone,
        'dutyTelephone': dutyTelephone,
        'remark': remark,
        'level': level,
        'owner': owner,
        'userId': userId,
        'userName': userName,
        'orgCode': orgCode,
        'companyName': companyName,
      };
}
