import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../../widgets/vetical_text.dart';

const gradients = [
  LinearGradient(colors: [
    Color(0xFF2dc2fd),
    Color(0xFF33b7fd),
    Color(0xFF4d8efe),
    Color(0xFF4e8cfe)
  ]),
  LinearGradient(colors: [
    Color(0xFF61d9a2),
    Color(0xFF5ad7a4),
    Color(0xFF2ac7b3),
    Color(0xFF24c4b4)
  ]),
  LinearGradient(colors: [
    Color(0xFFcd92fd),
    Color(0xFFc791fd),
    Color(0xFF978afe),
    Color(0xFF918afe)
  ]),
  LinearGradient(colors: [
    Color(0xFFffa66f),
    Color(0xFFffa072),
    Color(0xFFff7091),
    Color(0xFFff6a94)
  ])
];

class BaseInfoContent extends StatelessWidget {
  final String title;
  final List<String> categories;
  final List<String> numbers;

  BaseInfoContent(
      {@required this.title, @required this.categories, @required this.numbers})
      : assert(categories.length != 0),
        assert(numbers.length != 0),
        assert(categories.length == numbers.length);

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(left: 18.px, top: 9.px),
          child: Text(
            title,
            style: Theme.of(context).textTheme.headline4,
          ),
        ),
        Padding(
          padding: EdgeInsets.symmetric(horizontal: 18.px, vertical: 21.px),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: categories.asMap().keys.map((e) {
              return VerticalText(
                numbers[e],
                gradient: gradients[e],
                category: categories[e],
              );
            }).toList(),
          ),
        )
      ],
    );
  }
}
