import 'package:base/consts/external_assets_package_key.dart';
import 'package:flutter/material.dart';
import 'package:base/view/common/banner_page.dart';
import '../../model/vehicle_basic_model.dart';

class BasicPage extends StatefulWidget {
  BasicBean baseBean;
  final String type; //1为装备 3为车辆
//基本信息
  BasicPage(this.baseBean, this.type);

  @override
  _BasicPageState createState() {
    return _BasicPageState();
  }
}

class _BasicPageState extends State<BasicPage> {
  List<BannerItem> bannerList = [];
  List<dynamic> basicList = [];
  String name = '';
  String qrcode = '';

  @override
  void initState() {
    //数据处理
    if (widget.type == '3') {
      if (widget.baseBean.img.length > 0) {
        for (int i = 0; i < widget.baseBean.img.length; i++) {
          Img model = widget.baseBean.img[i];
          BannerItem item = BannerItem.defaultBannerItem(model.url == null ? ' ' : model.url, '');
          bannerList.add(item);
        }
      }
      name = widget.baseBean.name == null ? " " : widget.baseBean.name;
      qrcode = widget.baseBean.qrCode == null ? " " : widget.baseBean.qrCode;
      final pream = {"name": "整车型号", "title": widget.baseBean.standard == null ? " " : widget.baseBean.standard};
      basicList.add(pream);
      final pream1 = {"name": "整车品牌", "title": widget.baseBean.brand == null ? " " : widget.baseBean.brand};
      basicList.add(pream1);
      //bean=BaseModel('生产厂商','美国某某消防车公司');
      final pream2 = {
        "name": "生产厂商",
        "title": widget.baseBean.manufacturerInfo.name == null ? " " : widget.baseBean.manufacturerInfo.name
      };
      basicList.add(pream2);
      final pream3 = {
        "name": "国   别",
        "title": widget.baseBean.countryName == null ? " " : widget.baseBean.countryName
      };
      basicList.add(pream3);
      //bean=BaseModel('底盘国别','美国');
      final pream4 = {
        "name": "底盘国别",
        "title": widget.baseBean.chassisCountryName == null ? " " : widget.baseBean.chassisCountryName
      };
      basicList.add(pream4);
      // bean=BaseModel('底盘品牌','美国大力神');
      final pream5 = {
        "name": "底盘品牌",
        "title": widget.baseBean.chassisBrand == null ? " " : widget.baseBean.chassisBrand
      };
      basicList.add(pream5);
      // bean=BaseModel('车牌号','消A23432432');
      final pream6 = {"name": "车牌号", "title": widget.baseBean.carNum == null ? " " : widget.baseBean.carNum};
      basicList.add(pream6);
    } else {
      if (widget.baseBean.equipmentBase.img.length > 0) {
        for (int i = 0; i < widget.baseBean.equipmentBase.img.length; i++) {
          Img model = widget.baseBean.equipmentBase.img[i];
          BannerItem item = BannerItem.defaultBannerItem(model.url == null ? ' ' : model.url, '');
          bannerList.add(item);
        }
      }
      name = widget.baseBean.equipmentBase?.equipName == null ? " " : widget.baseBean.equipmentBase.equipName;
      qrcode = widget.baseBean.equipmentBase.qrCode == null ? " " : widget.baseBean.equipmentBase.qrCode;
      final pream = {
        "name": "分类",
        "title": widget.baseBean.equipmentBase?.categoryName == null ? " " : widget.baseBean.equipmentBase.categoryName
      };
      basicList.add(pream);
      final pream1 = {
        "name": "所在位置",
        "title": widget.baseBean.equipmentBase?.description == null ? " " : widget.baseBean.equipmentBase.description
      };
      basicList.add(pream1);
      final pream3 = {
        "name": "入库时间",
        "title": widget.baseBean.equipmentBase?.createTime == null ? " " : widget.baseBean.equipmentBase.createTime
      };
      basicList.add(pream3);

      final pream4 = {
        "name": "规格型号",
        "title": widget.baseBean.equipmentBase?.standard == null ? " " : widget.baseBean.equipmentBase.standard
      };
      basicList.add(pream4);

      final pream5 = {
        "name": "国别",
        "title": widget.baseBean.equipmentBase?.country == null ? " " : widget.baseBean.equipmentBase.country
      };
      basicList.add(pream5);

      final pream6 = {
        "name": "保养周期(月)",
        "title": widget.baseBean.equipmentBase?.maintenanceCycle == null
            ? " "
            : widget.baseBean.equipmentBase.maintenanceCycle
      };
      basicList.add(pream6);

      final pream7 = {
        "name": "报废年限",
        "title": widget.baseBean.equipmentBase?.expiryDate == null ? " " : widget.baseBean.equipmentBase.expiryDate
      };
      basicList.add(pream7);

      final pream8 = {
        "name": "生产厂商",
        "title": widget.baseBean.manufacturerInfo?.name == null ? " " : widget.baseBean.manufacturerInfo.name
      };
      basicList.add(pream8);

      final pream9 = {
        "name": "品牌",
        "title": widget.baseBean.equipmentBase?.brand == null ? " " : widget.baseBean.equipmentBase.brand
      };
      basicList.add(pream9);
    }

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Material(
        color: const Color(0xfff5f5f5),
        child: SingleChildScrollView(
            padding: const EdgeInsets.only(left: 10, right: 10, top: 15, bottom: 40),
            child: Column(
              children: [
                Material(
                    color: Colors.white,
                    //圆角
                    borderRadius: BorderRadius.circular(10.0),
                    shadowColor: Colors.black38,
                    elevation: 8.0,
                    child: Column(
                      children: [
                        //banner图
                        BannerWidget(
                          180.0,
                          bannerList,
                          bannerPress: (pos, item) {
                            print('第 $pos 点击了');
                          },
                        ),
                        //设备名称编号
                        Container(
                          padding: const EdgeInsets.only(left: 8, top: 10, bottom: 10),
                          alignment: Alignment.centerLeft,
                          child: Column(
                            children: [
                              Container(
                                alignment: Alignment.centerLeft,
                                child: Text(
                                  name,
                                  style: const TextStyle(fontSize: 15, color: Color(0xff333333)),
                                  textAlign: TextAlign.left,
                                ),
                              ),
                              Container(
                                margin: const EdgeInsets.only(top: 10),
                                child: Row(
                                  children: [
                                    Image.asset(
                                      'assets/images/ewm.png',
                                      package: ExternalAssetsPackageKey.BASE,
                                      width: 12,
                                      height: 12,
                                    ),
                                    Container(
                                      width: 10,
                                    ),
                                    Text(
                                      qrcode.indexOf('#') > 0 ? qrcode.substring(3) : qrcode,
                                      style: const TextStyle(fontSize: 12, color: Color(0xff666666)),
                                      textAlign: TextAlign.left,
                                    )
                                  ],
                                ),
                              )
                            ],
                          ),
                        )
                      ],
                    )),
                widget.type == '3'
                    ? Container(
                        margin: const EdgeInsets.only(top: 20),
                        //基本信息列表
                        child: ListView.builder(
                            physics: const NeverScrollableScrollPhysics(),
                            key: const PageStorageKey('data'),
                            itemCount: basicList.length,
                            shrinkWrap: true,
                            itemBuilder: (BuildContext context, int index) => ListItemView(index, basicList[index])),
                      )
                    : Container(
                        margin: const EdgeInsets.only(top: 20),
                        //基本信息列表
                        child: ListView.builder(
                            physics: const NeverScrollableScrollPhysics(),
                            key: const PageStorageKey('data'),
                            itemCount: basicList.length,
                            shrinkWrap: true,
                            itemBuilder: (BuildContext context, int index) => ListEquipView(index, basicList[index])),
                      ),

                //)
              ],
            )));
  }
}

class ListEquipView extends StatelessWidget {
  int row;
  dynamic bean;

  ListEquipView(this.row, this.bean, {Key key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      alignment: Alignment.centerLeft,
      //单双行con颜色
      color: row % 2 == 0 ? Colors.white : const Color(0xffefeff4),
      child: row == 0
          ? getCoulTextView()
          : row == 4
              ? getCoulTextView()
              : getTextView(),
    );
  }

  //row=0|4返回文字view
  getCoulTextView() {
    return Container(
        child: Column(
      children: <Widget>[
        Container(
          color: const Color(0xfff5f5f5),
          height: row == 4 ? 50 : 0,
        ),
        Container(
          alignment: Alignment.centerLeft,
          height: 30,
          padding: const EdgeInsets.all(5),
          color: const Color(0xff00ccff),
          child: Text(
            row == 4 ? '基本信息' : '入库信息',
            style: const TextStyle(fontSize: 12, color: Color(0xff333333)),
            textAlign: TextAlign.left,
          ),
        ),
        Container(
            height: 40,
            padding: const EdgeInsets.all(5),
            child: Row(children: <Widget>[
              Container(
                  width: 70,
                  // color: Colors.red,
                  child: Text(
                    bean['name'] + ' :  ',
                    style: const TextStyle(fontSize: 12, color: Color(0xff666666)),
                    textAlign: TextAlign.left,
                  )),
              Text(
                bean['title'],
                style: const TextStyle(fontSize: 12, color: Color(0xff333333)),
                textAlign: TextAlign.left,
              )
            ]))
      ],
    ));
  }

  //返回文字view
  getTextView() {
    return Container(
        height: 40,
        padding: const EdgeInsets.all(5),
        child: Row(children: <Widget>[
          Container(
              width: 110,
              //color: Colors.red,
              child: Text(
                bean['name'] + ' :  ',
                style: const TextStyle(fontSize: 12, color: Color(0xff666666)),
                textAlign: TextAlign.left,
              )),
          Text(
            bean['title'],
            style: const TextStyle(fontSize: 12, color: Color(0xff333333)),
            textAlign: TextAlign.left,
          )
        ]));
  }
}

class ListItemView extends StatelessWidget {
  ListItemView(this.row, this.bean, {Key key}) : super(key: key);
  int row;
  dynamic bean;

  //EmergencyBean bean;
  @override
  Widget build(BuildContext context) {
    return Container(
      alignment: Alignment.centerLeft,
      //判断输入图片还是文字给予不同高度
      height: bean['name'] == '3C证书' ? MediaQuery.of(context).size.width : 40.0,
      //单双行con颜色
      color: row % 2 == 0 ? Colors.white : const Color(0xffefeff4),
      child: bean['name'] == '3C证书' ? getImageView() : getTextView(),
    );
  }

  //返回文字view
  getTextView() {
    return Container(
        padding: const EdgeInsets.all(5),
        child: Row(children: <Widget>[
          Container(
              width: 70,
              child: Text(
                bean['name'] + ' :  ',
                style: const TextStyle(fontSize: 12, color: Color(0xff666666)),
                textAlign: TextAlign.left,
              )),
          Expanded(
              child: Text(
            bean['title'],
            style: const TextStyle(fontSize: 12, color: Color(0xff333333)),
            textAlign: TextAlign.left,
          ))
        ]));
  }

  //返回图片view
  getImageView() {
    return Container(
        color: const Color(0xfff5f5f5),
        child: Column(
          children: [
            Container(
                color: Colors.black12,
                padding: const EdgeInsets.all(10),
                width: 70,
                alignment: Alignment.centerLeft,
                child: Text(
                  bean['name'] + ' :  ',
                  style: const TextStyle(fontSize: 15, color: Color(0xff666666)),
                  textAlign: TextAlign.left,
                )),
            Container(
              height: 10,
              color: Colors.white,
              padding: const EdgeInsets.only(top: 5, left: 0, right: 0),
            ),
            Container(
              padding: const EdgeInsets.all(5.0),
              color: Colors.white,
              child: Image.network(bean['title'], fit: BoxFit.fitWidth),
            )
          ],
        ));
  }
}
