import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import 'package:base/consts/color.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

class ImageListView extends StatefulWidget {
  final List<Image> imageList;
  const ImageListView(this.imageList);
  @override
  State<StatefulWidget> createState() {
    return _ImageListViewState();
  }
}

class _ImageListViewState extends State<ImageListView> {
  List<Image> _imageList = [];
  String theme = '';
  @override
  void initState() {
    super.initState();
    _imageList = widget.imageList ?? [];
    initConfig();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }
    return Scaffold(
        appBar: AppBar(
          title: const Text(
            '照片列表',
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
        ),
        body: (_imageList == null || _imageList.isEmpty)
            ? Container()
            : Wrap(
                children: _imageList.map((f) {
                return Stack(
                  children: <Widget>[
                    Container(
                      child: GestureDetector(
                        child: Container(
                          padding: const EdgeInsets.only(right: 5),
                          child: f,
                          width: 160,
                          height: 100,
                        ),
                        onTap: () {
                          Navigator.push(context, MaterialPageRoute(builder: (context) {
                            return ImageView(f);
                          }));
                        },
                      ),
                    )
                  ],
                );
              }).toList()));
  }
}
