import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/CheckExecute/query_point_detail.dart';
import '../../services/CheckRecordServices.dart';
import '../../services/check_point_service.dart';
import '../../view/CheckExecute/send_card.dart';

class CheckExecSpotDetail extends StatefulWidget {
  final num pointId;
  final bool canSendCard;

  const CheckExecSpotDetail(this.pointId, this.canSendCard);

  @override
  State<StatefulWidget> createState() {
    return _CheckExecSpotDetail();
  }
}

class _CheckExecSpotDetail extends State<CheckExecSpotDetail> {
  bool _switchSelected = true;
  QueryPointDetail detail;
  String strRouts = '';
  String strClassify = '';
  String permissionList = '';
  String theme = '';

  @override
  void initState() {
    super.initState();
    getData();
  }

  Future<void> getPermissionData() async {
    await SharedPreferences.getInstance().then((sp) {
      String str = sp.get('permissionList');
      setState(() {
        permissionList = str;
        theme = sp.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  bool checkPermission(String permission) {
    if (permissionList == null || permissionList.isEmpty) return false;
    bool hasPermission = false;
    List permissions = permissionList.split(',');
    if (permissions.isEmpty) {
      hasPermission = false;
    } else {
      permissions.forEach((f) {
        print(f);
        if (f == permission) {
          hasPermission = true;
        }
      });
    }
    return hasPermission;
  }

  Future<void> getData() async {
    await getPermissionData();
    await getQueryPointDetail(widget.pointId).then((data) {
      if (data == null) {
        return;
      }
      setState(() {
        detail = data;
        _switchSelected = detail.pointInfo?.offline;
        String _routs = '';
        data.routs.forEach((r) {
          _routs = _routs + r.routeName + ';';
        });
        strRouts = _routs;
        String _classify = '';
        data.classifies.forEach((c) {
          _classify = _classify + c.classifyName + ';';
        });
        strClassify = _classify;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (detail == null) {
      return Scaffold(
        appBar: AppBar(
          title: const Text(
            '巡检点详情',
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
        ),
      );
    }
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: AppBar(
        title: const Text(
          '巡检点详情',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: SingleChildScrollView(
        child: Container(
          color: Colors.white,
          child: Column(
            children: <Widget>[
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '巡检点名称',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Expanded(
                      child: Text(
                          detail.pointInfo == null || detail.pointInfo.pointName == null
                              ? ''
                              : detail.pointInfo.pointName,
                          maxLines: 2,
                          overflow: TextOverflow.clip)),
                  const SizedBox(
                    width: 10,
                  )
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '点编号',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Expanded(
                    child: Text(detail.pointInfo.pointNo ?? '', maxLines: 2, overflow: TextOverflow.clip),
                  ),
                  const SizedBox(
                    width: 10,
                  )
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '点类型',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Expanded(child: Text(detail.pointInfo.fixed ?? '', maxLines: 2, overflow: TextOverflow.clip)),
                  const SizedBox(
                    width: 10,
                  )
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '归属区域\\部门',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Expanded(
                      child: Text(detail.pointInfo.departmentName ?? '', maxLines: 2, overflow: TextOverflow.clip)),
                  const SizedBox(
                    width: 10,
                  )
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '责任人',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Expanded(child: Text(detail.pointInfo.userName ?? '', maxLines: 2, overflow: TextOverflow.clip)),
                  const SizedBox(
                    width: 10,
                  )
                ],
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 100,
                    child: const Text(
                      '巡检线路',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Container(
                    padding: const EdgeInsets.only(left: 0, top: 10),
                    width: 250,
                    height: 50,
                    child: Text(strRouts),
                  ),
                ],
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 100,
                    height: 50,
                    child: const Text(
                      '检查项目',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Container(
                    padding: const EdgeInsets.only(left: 0, top: 10),
                    width: 250,
                    child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: detail.inputItems.keys.map((f) {
                          return Container(
                              width: 280,
                              child: Column(
                                children: <Widget>[
                                  Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: <Widget>[
                                      f == '其他'
                                          ? Container()
                                          : Container(
                                              height: 20,
                                              child: Text(
                                                f,
                                                style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
                                              ),
                                              alignment: Alignment.topLeft,
                                            ),
                                      Container(
                                        padding: const EdgeInsets.only(top: 5),
                                        child: Column(
                                            crossAxisAlignment: CrossAxisAlignment.start,
                                            children: detail.inputItems[f].map((item) {
                                              return Text(
                                                item.inputItenName ?? '',
                                                style: const TextStyle(fontWeight: FontWeight.w500, fontSize: 14),
                                              );
                                            }).toList()),
                                      )
                                    ],
                                  ),
                                  Container(
                                    padding: const EdgeInsets.only(bottom: 5),
                                  ),
                                  const Divider(
                                    height: 1,
                                  ),
                                ],
                              ));
                        }).toList()),
                  ),
                ],
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),
              checkPermission('/OfflineMode') && widget.canSendCard
                  ? Row(
                      children: <Widget>[
                        Container(
                          padding: const EdgeInsets.only(left: 20, top: 10),
                          width: 150,
                          height: 40,
                          child: const Text(
                            '离线巡检',
                            style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                          ),
                        ),
                        const Padding(padding: EdgeInsets.only(left: 140)),
                        Switch(
                          value: _switchSelected, //当前状态
                          activeColor: Theme.of(context).primaryColor,
                          onChanged: (value) {
                            setState(() {
                              _switchSelected = value;
                              // 设置离线巡检模式
                              setPatrolModeValue();
                            });
                          },
                        ),
                      ],
                    )
                  : Container(),
              checkPermission('/OfflineMode') && checkPermission('AppNFC') && widget.canSendCard
                  ? const Divider()
                  : Container(),
              checkPermission('AppNFC') && widget.canSendCard
                  ? GestureDetector(
                      child: Row(
                        children: <Widget>[
                          Container(
                            padding: const EdgeInsets.only(left: 20, top: 10),
                            width: 150,
                            height: 40,
                            child: const Text(
                              'NFC发卡',
                              style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                            ),
                          ),
                          Container(
                            padding: const EdgeInsets.only(left: 20, top: 10),
                            width: 180,
                            height: 40,
                            child: const Text(
                              '',
                              style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                            ),
                          ),
                          // Padding (padding: EdgeInsets.only(left: 180)),
                          Icon(
                            Icons.keyboard_arrow_right,
                            color: Theme.of(context).primaryColor,
                            size: 16,
                          ),
                        ],
                      ),
                      onTap: () {
                        //SendCard();
                        Navigator.push(context, MaterialPageRoute(builder: (context) {
                          return SendCard(detail.pointInfo.pointNo);
                        }));
                      },
                    )
                  : Container(),
              (checkPermission('/OfflineMode') || checkPermission('AppNFC')) && widget.canSendCard
                  ? Container(
                      color: Colors.grey[100],
                      height: 10,
                    )
                  : Container(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text.rich(TextSpan(children: [
                      TextSpan(
                        text: '备注说明',
                        style: TextStyle(
                          fontWeight: FontWeight.w500,
                          fontSize: 16,
                        ),
                      ),
                    ])),
                  ),
                  const Padding(padding: EdgeInsets.only(left: 179)),
                  Icon(
                    Icons.receipt,
                    color: Theme.of(context).primaryColor,
                    size: 16,
                  ),
                ],
              ),
              const Divider(),
              Container(
                padding: const EdgeInsets.only(left: 20, right: 10),
                child: Text(detail.pointInfo.remark ?? ''),
                width: double.infinity,
              ),
              const Divider(),
            ],
          ),
        ),
      ),
    );
  }

  Future<void> setPatrolModeValue() async {
    // 设置离线巡检
    await setPatrolMode(widget.pointId, _switchSelected).then((data) {});
  }
}
