import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:equipment_manage/routes/routes.dart'
    as equipment_manager_routes;
import 'package:offline/routes/routes.dart' as offline_routes;
import 'package:safe_control/routes/routes.dart' as safe_control_routes;

import 'package:base/routes/routes.dart' as base_routes;

import 'package:base/services/application.dart';
import 'package:base/utils/app_theme.dart';
import 'package:base/view/login/login.dart';

import 'package:base/consts/global_config.dart';

void initSysConfig(){
  GlobalConfig.appKey = 'AMOS_ADMIN';
  GlobalConfig.product = 'AMOS-APP-ADMIN';

  /// 设置极光推送 appKey
  GlobalConfig.jpushKey = 'b306b45e4c49f1c8dc640055';
  GlobalConfig.loginSysName = '安全预控系统';
  GlobalConfig.loginFooter = '亿江（北京）科技发展有限公司';
  GlobalConfig.showSysConfig = false;
}

class MyApp extends StatelessWidget {
  MyApp() {
    initSysConfig();

    final router = FluroRouter();
    base_routes.Routes.configureRoutes(router);
    safe_control_routes.Routes.configureRoutes(router);
    equipment_manager_routes.Routes.configureRoutes(router);
    offline_routes.Routes.configureRoutes(router);
    Application.router = router;
  }

  @override
  Widget build(BuildContext context) {
    SizeFit.initialize(standardSize: 750);
    return teamStationManagement();
  }

  //队站管理
  MaterialApp teamStationManagement() {
    return MaterialApp(
        localizationsDelegates: const [
          GlobalMaterialLocalizations.delegate,
          GlobalWidgetsLocalizations.delegate,
        ],
        supportedLocales: const [
          Locale('zh', 'CH'),
          Locale('en', 'US'),
        ],
        debugShowCheckedModeBanner: false,
        title: '装备管理',
        onGenerateRoute: Application.router.generator,
        theme: AppTheme.norTheme,
        home: Login());
  }
}
