import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../../widgets/back_button.dart';

class NotFoundPage extends StatelessWidget {
  const NotFoundPage();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('未知页面'),
      ),
      body: buildContent(),
    );
  }

  Widget buildContent() {
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          Image.asset(
            'assets/images/not_found.png',
            width: 128.px,
          ),
          SizedBox(
            height: 36.px,
          ),
          Text(
            '抱歉，您访问的页面不存在',
            style: TextStyle(fontSize: 12.px, color: const Color(0xFF999999)),
          )
        ],
      ),
    );
  }
}
