import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';

import '../view/common/not_found_page.dart';
import 'route_handler.dart';

mixin Routes {
  ///登录页
  static String login = '/login';

  ///首页
  static String main = '/main';

  ///首页公司部门选择页面
  static String selectCompanyRole = '/selectCompanyRole';

  ///角色选择页面
  static String selectRoleList = '/selectRoleList';

  ///服务器地址配置页面
  static String serviceConfig = '/serviceConfig';

  ///我的
  static String pswdChangePage = '/PswdChangePage';
  static String contactPage = '/ContactPage';
  static String subscribePage = '/SubscribePage';

  static void configureRoutes(FluroRouter router) {
    ///404页面
    router.notFoundHandler = Handler(
        handlerFunc: (BuildContext context, Map<String, List<String>> params) {
      return NotFoundPage();
    });
    router.define(login, handler: loginHandler);
    router.define(main, handler: mainHandler);
    router.define(selectCompanyRole, handler: selectCompanyRoleHandler);
    router.define(selectRoleList, handler: selectRoleListHandler);
    router.define(serviceConfig, handler: serviceConfigHandler);

    ///我的
    router.define(pswdChangePage, handler: pswdChangeHandler);
    router.define(contactPage, handler: contactHandler);
    router.define(subscribePage, handler: subscribeHandler);
  }
}
