import 'package:flutter/material.dart';
import '../../../model/ContactInfo.dart';
import 'contactinfo.dart';

//通讯录列表项
//qi 2019.03.03
class ContactItem extends StatelessWidget {
  //好友数据
  final ChildInfo item;
  final bool res;
  final String type;
  final BuildContext contexts;

  const ContactItem({this.item, this.res, this.type, this.contexts});

  @override
  Widget build(BuildContext context) {
    return item.children.isNotEmpty
        ? Container(
            child: ExpansionPanelList(children: [
              ExpansionPanel(
                  headerBuilder: (context, isExpanded) {
                    return ListTile(
                      title: Text(item.name + '(' + item.children.length.toString() + ')'),
                    );
                  },
                  body: ListView.builder(
                      physics: const NeverScrollableScrollPhysics(),
                      itemCount: item.children.length,
                      shrinkWrap: true,
                      itemBuilder: (BuildContext context, int i) {
                        return Container(
                          color: Colors.white,
                          alignment: Alignment.centerLeft,
                          child: ContactItem(type: type, contexts: contexts, item: item.children[i]),
                        );
                      }),
                  isExpanded: res)
            ]
                // }).toList(),
                ),
          )
        : Container(
            margin: const EdgeInsets.only(top: 5.0),
            decoration: const BoxDecoration(
              color: Colors.white,
              //每条列表项底部家一个边框
              border: Border(bottom: BorderSide(width: 0.5, color: Color(0xffd9d9d9))),
            ),
            height: 60.0,
            child: FlatButton(
              onPressed: () {
                if (type == '1') {
                  Navigator.of(contexts).pop(item);
                } else {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                        builder: (context) => Contactinfo(
                              info: item,
                            )),
                  );
                }
                //跳转到联系人信息页面
              },
              child: Row(
                children: [
                  Column(
                    children: <Widget>[
                      CircleAvatar(
                          foregroundColor: Colors.white,
                          backgroundColor: Theme.of(context).primaryColor,
                          radius: 25.0,
                          child: Text(item.label[0]))
                    ],
                  ),
                  const Padding(padding: EdgeInsets.only(left: 5.0)),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Container(
                        padding: const EdgeInsets.only(bottom: 5.0),
                        child: Text(
                          item.label,
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          );
  }
}
