import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';


enum EquipmentType { equip, car }

class CommonSingleCardItem extends StatelessWidget {
  final String title;
  final String count;
  final Image image;
  final Function(Map data) onPress;
  final EquipmentType equipmentType;

  CommonSingleCardItem(
      {this.title,
      this.count,
      this.image,
      this.onPress,
      this.equipmentType = EquipmentType.car});

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: () {
        if (onPress != null) {
          onPress({});
        }
      },
      child: Card(
        shape:
            RoundedRectangleBorder(borderRadius: BorderRadius.circular(5.px)),
        shadowColor: Color(0xFF455b63).withOpacity(0.08),
        child: equipmentType == EquipmentType.equip
            ? buildEquip(context)
            : buildCar(context),
      ),
    );
  }

  Widget buildEquip(BuildContext context) {
    return Row(
      children: <Widget>[
        Padding(
            padding: EdgeInsets.fromLTRB(15.px, 15.px, 10.px, 15.px),
            child: image),
        Expanded(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              Text(
                title ?? "",
                style: Theme.of(context)
                    .textTheme
                    .headline2
                    .copyWith(color: Color(0xFF333333)),
              ),
              SizedBox(
                height: 5.px,
              ),
              Text(
                "库存:1双",
                style: Theme.of(context)
                    .textTheme
                    .headline6
                    .copyWith(color: Color(0xFF999999)),
              ),
              Text("标志码:62164921601280",
                  style: Theme.of(context)
                      .textTheme
                      .headline6
                      .copyWith(color: Color(0xFF999999)))
            ],
          ),
        ),
        Icon(
          Icons.keyboard_arrow_right,
          color: Colors.grey,
        ),
        SizedBox(
          width: 10.px,
        )
      ],
    );
  }

  Widget buildCar(BuildContext context) {
    return Row(
      children: <Widget>[
        Padding(
            padding: EdgeInsets.fromLTRB(15.px, 15.px, 10.px, 15.px),
            child: image),
        Expanded(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              Text(
                title ?? "",
                style: Theme.of(context)
                    .textTheme
                    .headline2
                    .copyWith(color: Color(0xFF333333)),
              ),
              SizedBox(
                height: 5.px,
              ),
              Text(
                "在位:1",
                style: Theme.of(context)
                    .textTheme
                    .headline6
                    .copyWith(color: Color(0xFF999999)),
              ),
              Text("车牌号:WJ15XWP446",
                  style: Theme.of(context)
                      .textTheme
                      .headline6
                      .copyWith(color: Color(0xFF999999)))
            ],
          ),
        ),
        Icon(
          Icons.keyboard_arrow_right,
          color: Colors.grey,
        ),
        SizedBox(
          width: 10.px,
        )
      ],
    );
  }
}
