import 'package:flutter/material.dart';
import 'package:flutter_svg_provider/flutter_svg_provider.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';


class ScanAlertDialog extends Dialog {
  final VoidCallback onTap;
  final bool barrierDismissible;

  const ScanAlertDialog(
      {Key key, @required this.onTap, this.barrierDismissible = false})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () {
        if (!barrierDismissible) {
          Navigator.of(context).pop();
        }
        return Future.value(false);
      },
      child: Material(
        type: MaterialType.transparency,
        child: Stack(
          fit: StackFit.expand,
          children: <Widget>[
            GestureDetector(onTap: () {
              if (!barrierDismissible) {
                Navigator.of(context).pop();
              }
            }),
            Center(
              child: Padding(
                padding: EdgeInsets.symmetric(horizontal: 60.px),
                child: Container(
                  decoration: ShapeDecoration(
                      color: Colors.white,
                      shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(5.px))),
                  width: double.infinity,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      buildTopBar(context),
                      buildContent(context),
                      buildButton(context)
                    ],
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget buildTopBar(context) {
    return Stack(children: [
      Container(
        padding: EdgeInsets.symmetric(vertical: 10.px),
        decoration: ShapeDecoration(
            color: const Color(0xFFefeff4),
            shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.only(
                    topLeft: Radius.circular(5.px),
                    topRight: Radius.circular(5.px)))),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Text(
              "提示",
              style: Theme.of(context).textTheme.headline4,
            )
          ],
        ),
      ),
      Positioned(
        right: 10.px,
        top: 8.px,
        child: SvgButton(
          src: "assets/images/icon_close.svg",
          imageSize: 12.px,
          onTap: () {
            Navigator.of(context).pop();
          },
        ),
      )
    ]);
  }

  Widget buildContent(context) {
    return Padding(
      padding: EdgeInsets.symmetric(vertical: 22.px),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          const Image(
            image: Svg("assets/images/icon_alert.svg", size: Size(24, 24)),
          ),
          SizedBox(
            width: 13.px,
          ),
          Text(
            "请先选择或者扫描位置",
            style: Theme.of(context).textTheme.headline3,
          )
        ],
      ),
    );
  }

  Widget buildButton(context) {
    return Container(
      width: double.infinity,
      height: 40.px,
      child: RaisedButton(
        shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.only(
                bottomLeft: Radius.circular(5.px),
                bottomRight: Radius.circular(5.px))),
        color: Colors.grey,
        child: Text('去选择',
            style: Theme.of(context)
                .textTheme
                .headline3
                .copyWith(color: Colors.white)),
        onPressed: onTap,
      ),
    );
  }
}
