import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../../utils/GetConfig.dart';

class PositionDescriptionDialog extends StatefulWidget {
  final ValueChanged<String> callback;
  final Function close;
  final String theme;
  const PositionDescriptionDialog({this.callback, this.close, this.theme});
  @override
  _PositionDescriptionDialogState createState() =>
      _PositionDescriptionDialogState();
}

class _PositionDescriptionDialogState extends State<PositionDescriptionDialog> {
  final TextEditingController _controller = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return StreamBuilder<Object>(builder: (context, snapshot) {
      return SingleChildScrollView(
        child: Container(
          padding:
              EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: <Widget>[
              buildTopBar(context),
              Container(
                height: 80.px,
                padding: EdgeInsets.symmetric(horizontal: 16.px),
                child: TextField(
                  autofocus: true,
                  keyboardType: TextInputType.text,
                  maxLines: 10,
                  controller: _controller,
                  inputFormatters: [
                    FilteringTextInputFormatter.allow(
                        RegExp('[a-zA-Z]|[\u4e00-\u9fa5]|[0-9]')),
                    LengthLimitingTextInputFormatter(50)
                  ],
                  //[FilteringTextInputFormatter.allow(RegExp("[a-zA-Z]")),],
                  decoration: const InputDecoration(
                      hintText: '输入位置描述', border: InputBorder.none),
                ),
              ),
              Container(
                width: double.infinity,
                height: 96.rpx,
                child: RaisedButton(
                  color: GetConfig.getColor(widget.theme),
                  onPressed: () {
                    if (widget.callback != null) {
                      widget.callback(_controller.text?.trim());
                    }
                    Navigator.of(context).pop();
                  },
                  child: Text(
                    '确定',
                    style: Theme.of(context)
                        .textTheme
                        .headline6
                        .copyWith(color: Colors.white),
                  ),
                ),
              )
            ],
          ),
        ),
      );
    });
  }

  Widget buildTopBar(context) {
    return Container(
      height: 44.px,
      child: Stack(children: [
        Container(
          padding: EdgeInsets.symmetric(vertical: 10.px),
          decoration: ShapeDecoration(
              color: const Color(0xFFefeff4),
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.only(
                      topLeft: Radius.circular(5.px),
                      topRight: Radius.circular(5.px)))),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Text(
                '位置描述',
                // style: Theme.of(context).textTheme.headline4,
              )
            ],
          ),
        ),
        Align(
            alignment: Alignment.centerRight,
            child: Container(
              padding: const EdgeInsets.only(right: 10),
              child: SvgButton(
                src: 'assets/images/icon_close.svg',
                imageSize: 12.px,
                onTap: () {
                  Navigator.of(context).pop();
                  if (widget.close != null) {
                    widget.close();
                  }
                },
              ),
            ))
      ]),
    );
  }
}
