class ConfigurationItemModel {
  ConfigurationItemModel({
    this.permissionType,
    this.isBlank,
    this.sort,
    this.agencyCode,
    this.appCode,
    this.parentId,
    this.path,
    this.menuAgent,
    this.children,
    this.hasPermission,
    this.isRoute,
    this.sequenceNbr,
    this.permissionName,
    this.frontComponent,
    this.icon,
  });

  String permissionType;
  bool isBlank;
  int sort;
  String agencyCode;
  String appCode;
  String parentId;
  String path;
  String menuAgent;
  List<ConfigurationItemModel> children;
  bool hasPermission;
  bool isRoute;
  String sequenceNbr;
  String permissionName;
  String frontComponent; // 用来区分跳转类型
  String icon;

  factory ConfigurationItemModel.fromJson(Map<String, dynamic> json) =>
      ConfigurationItemModel(
        permissionType: json["permissionType"],
        isBlank: json["isBlank"],
        sort: json["sort"],
        agencyCode: json["agencyCode"],
        appCode: json["appCode"],
        parentId: json["parentId"],
        path: json["path"],
        menuAgent: json["menuAgent"],
        children: json["children"] == null
            ? null
            : List<ConfigurationItemModel>.from(json["children"]
                .map((x) => ConfigurationItemModel.fromJson(x))),
        hasPermission: json["hasPermission"],
        isRoute: json["isRoute"],
        sequenceNbr: json["sequenceNbr"],
        permissionName: json["permissionName"],
        frontComponent: json["frontComponent"],
        icon: json["icon"] == null ? null : json["icon"],
      );

  Map<String, dynamic> toJson() => {
        "permissionType": permissionType,
        "isBlank": isBlank,
        "sort": sort,
        "agencyCode": agencyCode,
        "appCode": appCode,
        "parentId": parentId,
        "path": path,
        "menuAgent": menuAgent,
        "children": children == null
            ? null
            : List<dynamic>.from(children.map((x) => x.toJson())),
        "hasPermission": hasPermission,
        "isRoute": isRoute,
        "sequenceNbr": sequenceNbr,
        "permissionName": permissionName,
        "frontComponent": frontComponent,
        "icon": icon == null ? null : icon,
      };
}
