import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:base/consts/color.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:base/services/application.dart';
import 'package:base/widgets/back_button.dart';
import 'package:base/widgets/common_single_card_item.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../routes/routes.dart';

GlobalKey<_CommonSingleEquipmentListContentState> childKey = GlobalKey();

class CommonSingleEquipmentList extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: const Color(0xFFefeff4),
      appBar: AppBar(
        title: const Text(
          '装备详情',
          style: TextStyle(color: Colors.black),
        ),
        centerTitle: true,
        leading: LeadingButton(
          theme: childKey.currentState.theme,
        ),
      ),
      body: CommonSingleEquipmentListContent(),
    );
  }
}

class CommonSingleEquipmentListContent extends StatefulWidget {
  @override
  _CommonSingleEquipmentListContentState createState() =>
      _CommonSingleEquipmentListContentState();
}

class _CommonSingleEquipmentListContentState
    extends State<CommonSingleEquipmentListContent> {
  @override
  void initState() {
    super.initState();
    initThemeConfig();
  }

  String theme = '';

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme =
            preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return ListView.builder(
        padding: EdgeInsets.symmetric(horizontal: 10.px, vertical: 5.px),
        itemCount: 10,
        itemBuilder: (ctx, index) {
          return CommonSingleCardItem(
            title: '全盔式消防头盔',
            count: "345",
            image: Image.asset(
              'assets/images/equip_cap.png',
              package: ExternalAssetsPackageKey.BASE,
              width: 70.px,
            ),
            onPress: (value) {
              const params = {"title": "车辆详情", "type": "1"};
              Application.navigateToPath(
                  context, Routes.equipCarExtinguishDetail,
                  params: params);
            },
          );
        });
  }
}
