import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/offline_plan_list_output.dart';
import '../../view/CheckExecute/send_card.dart';

class OfflineCheckExecSpotDetail extends StatefulWidget {
  final Point point;
  OfflineCheckExecSpotDetail(this.point);

  @override
  State<StatefulWidget> createState() {
    return _OfflineCheckExecSpotDetail();
  }
}

class _OfflineCheckExecSpotDetail extends State<OfflineCheckExecSpotDetail> {
  String permissionList = "";
  String theme = '';
  @override
  void initState() {
    super.initState();

    getPermissionData();
  }

  getPermissionData() async {
    await SharedPreferences.getInstance().then((sp) {
      String str = sp.get('permissionList');
      setState(() {
        permissionList = str;
        this.theme = sp.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  checkPermission(String permission) {
    if (permissionList == null || permissionList.isEmpty) return false;
    bool hasPermission = false;
    List permissions = permissionList.split(",");
    if (permissions.length <= 0) {
      hasPermission = false;
    } else {
      permissions.forEach((f) {
        print(f);
        if (f == permission) {
          hasPermission = true;
        }
      });
    }

    return hasPermission;
  }

  @override
  Widget build(BuildContext context) {
    if (this.widget.point == null) {
      return Scaffold(
        appBar: AppBar(
          title: Text(
            "巡检点详情",
            style: TextStyle(color: Colors.black, fontSize: 19),
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
          backgroundColor: KColorConstant.topBarColor,
          leading: new Container(
            child: GestureDetector(
              onTap: () => Navigator.pop(context),
              child: Icon(Icons.keyboard_arrow_left,
                  color: GetConfig.getColor(theme), size: 32),
            ),
          ),
        ),
      );
    }
    return Scaffold(
      appBar: AppBar(
        title: Text(
          "巡检点详情",
          style: TextStyle(color: Colors.black, fontSize: 19),
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
        backgroundColor: KColorConstant.topBarColor,
        leading: new Container(
          child: GestureDetector(
            onTap: () => Navigator.pop(context),
            child: Icon(Icons.keyboard_arrow_left,
                color: GetConfig.getColor(theme), size: 32),
          ),
        ),
      ),
      body: SingleChildScrollView(
        child: Column(
          children: <Widget>[
            Row(
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 150,
                  height: 40,
                  child: Text(
                    "巡检点名称",
                    style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                  ),
                ),
                Expanded(
                    child: Text(
                  this.widget.point.name ?? "",
                  overflow: TextOverflow.ellipsis,
                  maxLines: 2,
                )),
              ],
            ),
            Divider(),
            Row(
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 150,
                  height: 40,
                  child: Text(
                    "点编号",
                    style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                  ),
                ),
                Text(this.widget.point.pointNO ?? ""),
              ],
            ),
            Divider(),
            Row(
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 150,
                  height: 40,
                  child: Text(
                    "点类型",
                    style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                  ),
                ),
                Text((this.widget.point.isFixed ?? "") == "1" ? "固定点" : "移动点"),
              ],
            ),
            Divider(),
            Row(
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 150,
                  height: 40,
                  child: Text(
                    "归属区域\\部门",
                    style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                  ),
                ),
                Text(this.widget.point.departmentName ?? ""),
              ],
            ),
            Divider(),
            Row(
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 150,
                  height: 40,
                  child: Text(
                    "责任人",
                    style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                  ),
                ),
                Text(this.widget.point.chargePerson ?? ""),
              ],
            ),
            Container(
              color: Colors.grey[100],
              height: 10,
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 100,
                  height: 60,
                  child: Text(
                    "巡检线路",
                    style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(left: 0, top: 10),
                  width: MediaQuery.of(context).size.width - 140,
                  child: Text(this.widget.point.routeName ?? ""),
                ),
              ],
            ),
            Container(
              color: Colors.grey[100],
              height: 10,
            ),
            // Row(
            //   mainAxisAlignment: MainAxisAlignment.start,
            //   crossAxisAlignment: CrossAxisAlignment.start,
            //   children: <Widget>[
            //     Container(
            //       padding: EdgeInsets.only(left: 20,top:10),
            //       width: 100,
            //       height: 60,
            //       child: Text("扩展分类",style: TextStyle(fontWeight: FontWeight.w500,fontSize: 16),),
            //     ),
            //     Container(
            //       padding: EdgeInsets.only(left: 0,top:10),
            //       width: MediaQuery.of(context).size.width-140,
            //       child: Text(this.widget.point.classifyNames??""),
            //     ),
            //   ],
            // ),
            Container(
              color: Colors.grey[100],
              height: 10,
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 100,
                  height: 50,
                  child: Text(
                    "检查项目",
                    style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(left: 0, top: 10),
                  width: MediaQuery.of(context).size.width - 140,
                  child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: this.widget.point.inputItems.map((inputItem) {
                        return Text(inputItem.name ?? "");
                      }).toList()),
                ),
              ],
            ),
            Container(
              color: Colors.grey[100],
              height: 10,
            ),

            checkPermission("AppNFC") ? Divider() : Container(),

            checkPermission("AppNFC")
                ? GestureDetector(
                    child: Row(
                      children: <Widget>[
                        Container(
                          padding: EdgeInsets.only(left: 20, top: 10),
                          width: 150,
                          height: 40,
                          child: Text(
                            "NFC发卡",
                            style: TextStyle(
                                fontWeight: FontWeight.w500, fontSize: 16),
                          ),
                        ),
                        Padding(
                            padding: EdgeInsets.only(
                                left: MediaQuery.of(context).size.width - 174)),
                        new Icon(
                          Icons.keyboard_arrow_right,
                          color: Colors.blue,
                          size: 16,
                        ),
                      ],
                    ),
                    onTap: () {
                      //SendCard();
                      Navigator.push(context,
                          MaterialPageRoute(builder: (context) {
                        return SendCard(this.widget.point.pointNO);
                      }));
                    },
                  )
                : Container(),

            checkPermission("AppNFC")
                ? Container(
                    color: Colors.grey[100],
                    height: 10,
                  )
                : Container(),
            Row(
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  width: 150,
                  height: 40,
                  child: Text.rich(TextSpan(children: [
                    // TextSpan(
                    //   text: "*",
                    //   style: TextStyle(
                    //       color: Colors.red
                    //   ),
                    // ),
                    TextSpan(
                      text: "备注说明",
                      style: TextStyle(
                        fontWeight: FontWeight.w500,
                        fontSize: 16,
                      ),
                    ),
                  ])),
                ),
                Padding(
                    padding: EdgeInsets.only(
                        left: MediaQuery.of(context).size.width - 190)),
                new Icon(
                  Icons.receipt,
                  color: Colors.grey,
                  size: 16,
                ),
                //new Icon(Icons.keyboard_arrow_right,color: Colors.blue,size: 16,),
              ],
            ),
            Divider(),
            // Row(
            //   children: <Widget>[
            Container(
                padding: EdgeInsets.only(left: 20, top: 0, right: 20),
                child:
                    // Column(
                    //   crossAxisAlignment: CrossAxisAlignment.start,
                    //   children: <Widget>[
                    Text(this.widget.point.remark != null ? this.widget.point.remark != 'null'?this.widget.point.remark:'' : '')
                //   ],
                // )
                ),
            //   ],
            // ),
            Divider(),
          ],
        ),
      ),
    );
  }
}
