import 'dart:convert' show json;

class QueryPointDetail {
  PointInfo pointInfo;

  Map<String, List<InputItems>> inputItems = {};
  List<Classify> classifies = [];
  List<Route> routs = [];
}

class PointInfo {
  int id;
  String departmentName;
  String fixed;
  String pointName;
  String pointNo;
  String remark;
  String routeName;
  String userName;
  bool offline;

  PointInfo.fromParams(
      {this.id,
      this.departmentName,
      this.fixed,
      this.pointName,
      this.pointNo,
      this.remark,
      this.routeName,
      this.userName,
      this.offline});

  factory PointInfo(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? PointInfo.fromJson(json.decode(jsonStr))
          : PointInfo.fromJson(jsonStr);

  PointInfo.fromJson(jsonRes) {
    id = jsonRes['id'];
    departmentName = jsonRes['departmentName'];
    fixed = jsonRes['fixed'];
    pointName = jsonRes['pointName'];
    pointNo = jsonRes['pointNo'];
    remark = jsonRes['remark'];
    routeName = jsonRes['routeName'];
    userName = jsonRes['userName'];
    offline = jsonRes['offline'];
  }

  @override
  String toString() {
    return '{"id": $id,"departmentName": ${departmentName != null ? '${json.encode(departmentName)}' : 'null'},"fixed": ${fixed != null ? '${json.encode(fixed)}' : 'null'},"pointName": ${pointName != null ? '${json.encode(pointName)}' : 'null'},"pointNo": ${pointNo != null ? '${json.encode(pointNo)}' : 'null'},"remark": ${remark != null ? '${json.encode(remark)}' : 'null'},"routeName": ${routeName != null ? '${json.encode(routeName)}' : 'null'},"userName": ${userName != null ? '${json.encode(userName)}' : 'null'}}';
  }
}

class InputItems {
  int inputItemNO;
  int pointId;
  String inputItenName;

  InputItems.fromParams({this.inputItemNO, this.pointId, this.inputItenName});

  factory InputItems(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? InputItems.fromJson(json.decode(jsonStr))
          : InputItems.fromJson(jsonStr);

  InputItems.fromJson(jsonRes) {
    inputItemNO = jsonRes['inputItemNO'];
    pointId = jsonRes['pointId'];
    inputItenName = jsonRes['inputItenName'];
  }

  @override
  String toString() {
    return '{"inputItemNO": $inputItemNO,"pointId": $pointId,"inputItenName": ${inputItenName != null ? '${json.encode(inputItenName)}' : 'null'}}';
  }
}

class Classify {
  int pointId;
  String classifyName;

  Classify.fromParams({this.pointId, this.classifyName});

  factory Classify(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? Classify.fromJson(json.decode(jsonStr))
          : Classify.fromJson(jsonStr);

  Classify.fromJson(jsonRes) {
    pointId = jsonRes['pointId'];
    classifyName = jsonRes['classifyName'];
  }

  @override
  String toString() {
    return '{"pointId": $pointId,"classifyName": ${classifyName != null ? '${json.encode(classifyName)}' : 'null'}}';
  }
}

class Route {
  int pointId;
  String routeName;

  Route.fromParams({this.pointId, this.routeName});

  factory Route(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? Route.fromJson(json.decode(jsonStr))
          : Route.fromJson(jsonStr);

  Route.fromJson(jsonRes) {
    pointId = jsonRes['pointId'];
    routeName = jsonRes['routeName'];
  }

  @override
  String toString() {
    return '{"pointId": $pointId,"routeName": ${routeName != null ? '${json.encode(routeName)}' : 'null'}}';
  }
}
