import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_datetime_picker/flutter_datetime_picker.dart';
import 'package:intl/intl.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/Hidden_Danger/hidden_danger_model.dart';
import '../../services/HiddenDanger.dart';
import '../../view/hidedanger_manage/hidden_danger_found.dart';

class HiddenDangerDelay extends StatefulWidget {
  final HideDangerInfoModel initData;
  final String taskId;
  HiddenDangerDelay(this.initData, this.taskId);
  @override
  _HiddenDangerDelay createState() => new _HiddenDangerDelay();
}

class _HiddenDangerDelay extends State<HiddenDangerDelay> {
  String theme = "blue";
  //延期时间
  TextEditingController delayDate = TextEditingController();

  bool canOperate = true;
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    getInitInfo();
  }

  void getInitInfo() async {
    await SharedPreferences.getInstance().then((data) {
      this.theme = data.getString("theme") ?? "blue";
    }).then((data) {});
  }

  _saveDelayDate() async {
    setState(() {
      canOperate = false;
    });
    var hd = new HideDanger();
    hd.delayLimitDate = this.delayDate;
    await saveReviewResult(hd, 15, this.widget.initData.currentFlowRecordId, {},
            this.widget.taskId, widget.initData.dangerId)
        .then((data) {
      if (data.success) {
        HiddenDangerFound.popUpMsg(data.message);
        Navigator.pop(context);
        Navigator.pop(context);
      } else {
        HiddenDangerFound.popUpMsg(data.message);
      }
      setState(() {
        canOperate = true;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(
          "延期申请",
          style: TextStyle(
            color: Colors.black,
            fontSize: 19,
          ),
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
        backgroundColor: Colors.white,
        leading: new Container(
          child: GestureDetector(
            onTap: () => Navigator.pop(context),
            child: Icon(Icons.keyboard_arrow_left,
                color: GetConfig.getColor(theme) /*GetConfig.getColor(theme)*/,
                size: 32),
          ),
        ),
        actions: <Widget>[
          GestureDetector(
              child: Container(
                padding: EdgeInsets.only(top: 15, right: 20),
                child: Text(
                  "提交",
                  style: TextStyle(
                      color: GetConfig.getColor(theme),
                      fontWeight: FontWeight.w800,
                      fontSize: 18),
                  textAlign: TextAlign.center,
                ),
              ),
              onTap: () {
                if (canOperate) {
                  if (!(this.delayDate.text == "" ||
                      this.delayDate.text == null)) {
                    _saveDelayDate();
                  } else {
                    HiddenDangerFound.popUpMsg("请输入延期时间！");
                  }
                } else {
                  HiddenDangerFound.popUpMsg("正在执行操作！请稍等...");
                }
              })
        ],
      ),
      body: Container(
        height: MediaQuery.of(context).size.height,
        child: Column(
          children: <Widget>[
            Container(
              height: 50.0,
              margin: EdgeInsets.only(left: 10.0, top: 10.0),
              child: new Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Text("说明:延期申请通过后更改原整改日期至延期日期！",
                      style: TextStyle(
                          color: Colors.red, fontWeight: FontWeight.w700))
                ],
              ),
            ),
            Container(
              height: 10,
              color: Color.fromRGBO(244, 244, 244, 1),
            ),
            Row(
              children: <Widget>[
                Expanded(
                  child: Container(
                    padding:
                        EdgeInsets.only(left: 10, top: 5, bottom: 5, right: 10),
                    width: MediaQuery.of(context).size.width,
                    child: Column(
                      children: <Widget>[
                        Row(
                          children: <Widget>[
                            Expanded(
                              child: Text(
                                "*",
                                style: TextStyle(color: Colors.red),
                              ),
                              flex: 0,
                            ),
                            Expanded(
                              child: Text(
                                "延期日期",
                                style: TextStyle(
                                    color: Colors.black, fontSize: 18),
                              ),
                              flex: 3,
                            ),
                            Expanded(
                              child: Container(
                                  width: MediaQuery.of(context).size.width - 50,
                                  margin: EdgeInsets.only(top: 5, bottom: 10),
                                  padding: EdgeInsets.only(
                                    top: 5,
                                    bottom: 5,
                                  ),
                                  color: Color.fromRGBO(244, 244, 244, 1),
                                  child: GestureDetector(
                                    child: Row(
                                      children: <Widget>[
                                        Expanded(
                                          child: Row(
                                            children: <Widget>[
                                              Expanded(
                                                flex: 9,
                                                child: TextField(
                                                  enabled: false,

                                                  ///只读属性
                                                  keyboardType:
                                                      TextInputType.number,
                                                  controller: delayDate,
                                                  autofocus: false,
                                                  maxLines: 1,
                                                  decoration: InputDecoration(
                                                    contentPadding:
                                                        const EdgeInsets
                                                                .symmetric(
                                                            vertical: 10.0,
                                                            horizontal: 10),
                                                    border: InputBorder.none,
                                                    hintText: "选择延期日期",
                                                    filled: true,
                                                    fillColor: Color.fromRGBO(
                                                        244, 244, 244, 1),
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                flex: 1,
                                                child: Icon(
                                                  Icons.date_range,
                                                  color:
                                                      GetConfig.getColor(theme),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                    onTap: () {
                                      DatePicker.showDatePicker(context,
                                          showTitleActions: true,
                                          minTime: DateTime(2000, 1, 1),
                                          maxTime: DateTime(2199, 12, 31),
                                          theme: DatePickerTheme(
                                              itemStyle: TextStyle(
                                                  color: Colors.black,
                                                  fontWeight: FontWeight.bold),
                                              doneStyle: TextStyle(
                                                  color:
                                                      GetConfig.getColor(theme),
                                                  fontSize: 16)),
                                          onConfirm: (date) {
                                        var selDate =
                                            new DateFormat("yyyy-MM-dd")
                                                .format(date);
                                        delayDate.text = new DateFormat(
                                                "yyyy-MM-dd HH:mm:ss")
                                            .format(DateTime.parse(selDate)
                                                .add(new Duration(days: 1))
                                                .add(
                                                    new Duration(seconds: -1)));
                                      },
                                          currentTime: DateTime.now(),
                                          locale: LocaleType.zh);
                                    },
                                  )),
                              flex: 7,
                            )
                          ],
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            )
          ],
        ),
      ),
      resizeToAvoidBottomPadding: false,
    );
  }
}
