import 'dart:convert';

import 'package:base/consts/color.dart';
import 'package:base/view/ImageViewPage.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/Hidden_Danger/hidden_danger_model.dart';
import '../../services/HiddenDanger.dart';
import '../../view/hidedanger_manage/hidden_danger_flowRecord.dart';
import '../../view/hidedanger_manage/hidden_danger_review.dart';

class HiddenDangerProcessedDetailsRescinded extends StatefulWidget {
  final int dangerId;
  final num state;
  final String taskId;
  final bool isFinish;

  const HiddenDangerProcessedDetailsRescinded(this.dangerId, this.taskId, this.isFinish, {this.state});

  @override
  _HiddenDangerProcessedDetailsRescinded createState() => _HiddenDangerProcessedDetailsRescinded();
}

class _HiddenDangerProcessedDetailsRescinded extends State<HiddenDangerProcessedDetailsRescinded> {
  bool get wantKeepAlive => true;
  bool isAnimating = false;
  String myUserId;
  HideDangerInfoModel initData;
  String theme = '';
  String imageUrl = '';
  int pageIndex = 0;
  bool hasNext = false;

  @override
  void initState() {
    super.initState();
    getInitInfo();
  }

  Future<void> getInitInfo() async {
    await SharedPreferences.getInstance().then((data) {
      if (data != null) {
        setState(() {
          theme = data.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
          imageUrl = data.getString('imageUrl') ?? '';
        });
      }
    }).then((data) {
      loadData();
    });
  }

  Future<void> loadData() async {
    setState(() {
      isAnimating = true;
    });
    await getHiddenDangerModel(context,widget.dangerId, widget.taskId, isFinish: widget.isFinish).then((data) {
      setState(() {
        if (data != null) {
          initData = data;
          List<String> photos = [];
          (initData.photoUrls ?? []).forEach((item) {
            photos.add(imageUrl + item);
          });
          initData.photoUrls = photos;
          if (widget.state != null && initData.dangerState != null && widget.state != initData.dangerState) {
            HiddenDangerReview.goToPage(initData.dangerState, initData.dangerId, widget.taskId, context);
          }
        }
        isAnimating = false;
      });
    });
  }

  var radioValue = 0;

  Color getLevelTextBgColor(int level) {
    if (level == 1) return Colors.orange;
    if (level == 2) return Colors.red;
    return Colors.black;
  }

  @override
  Widget build(BuildContext context) {
    if (initData == null || initData?.dangerId == null) {
      return Scaffold(
          appBar: AppBar(
        title: const Text(
          '隐患详情',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ));
    }

    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '隐患详情',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: SingleChildScrollView(
        child: Container(
          color: Colors.white,
          child: Column(
            children: <Widget>[
              initData.dangerType == 2
                  ? Column(children: <Widget>[
                      // 风险点名称
                      Row(
                        children: <Widget>[
                          Expanded(
                            flex: 5,
                            child: Container(
                              padding: const EdgeInsets.only(left: 10, top: 10),
                              width: 150,
                              height: 50,
                              child: const Text(
                                '点名称',
                                style: TextStyle(
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                          ),
                          Expanded(
                            flex: 10,
                            child: Text(initData.riskInfo == null ? '-' : initData.riskInfo.pointName),
                          )
                        ],
                      ),
                      // Divider(),
                      //点编号
                      Row(
                        children: <Widget>[
                          Expanded(
                            flex: 5,
                            child: Container(
                              padding: const EdgeInsets.only(left: 10, top: 10),
                              width: 150,
                              height: 50,
                              child: const Text(
                                '点编号',
                                style: TextStyle(
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                          ),
                          Expanded(
                            flex: 10,
                            child: Text(initData.riskInfo == null ? '-' : initData.riskInfo.pointNo),
                          )
                        ],
                      ),
                      Row(
                        children: <Widget>[
                          Expanded(
                            flex: 5,
                            child: Container(
                              padding: const EdgeInsets.only(left: 10, top: 10),
                              width: 150,
                              height: 50,
                              child: const Text(
                                '等级',
                                style: TextStyle(
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                          ),
                          Expanded(
                            flex: 10,
                            child: Text('${initData.riskInfo != null ? initData.riskInfo.pointLevel : '--'}'),
                          )
                        ],
                      ),
                      //分割线
                      Container(
                        color: Colors.grey[100],
                        height: 10,
                      ),
                      Row(
                        children: <Widget>[
                          Container(
                            padding: const EdgeInsets.only(left: 10, top: 10),
                            height: 50,
                            child: const Text(
                              '检查依据',
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                          ),
                        ],
                      ),
                      initData.riskInfo != null && initData.riskInfo.basis != null
                          ? Column(
                              children: initData.riskInfo.basis.map((base) {
                                return Container(
                                  height: 30,
                                  decoration: const BoxDecoration(
                                      border: Border(bottom: BorderSide(color: Color.fromRGBO(244, 244, 244, 1)))),
                                  width: MediaQuery.of(context).size.width,
                                  margin: const EdgeInsets.only(left: 30),
                                  child: Text(
                                    json.decode(base)['name'].toString(),
                                    style: const TextStyle(color: Colors.black, fontSize: 16),
                                  ),
                                );
                              }).toList(),
                            )
                          : Container(),
                      Container(
                        color: Colors.grey[100],
                        height: 10,
                      ),
                    ])
                  : const Text(''),
              //隐患名称
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: const <Widget>[
                          Expanded(
                            child: Text(
                              '隐患名称',
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Container(
                      child: Text(initData.dangerName ?? ''),
                      padding: const EdgeInsets.only(top: 5, right: 10),
                    ),
                  ),
                ],
              ),
              //隐患地点
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: const <Widget>[
                          Expanded(
                            child: Text(
                              '隐患地点',
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(initData.position ?? '-'),
                  ),
                ],
              ),
              //隐患等级
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: const <Widget>[
                          Expanded(
                            child: Text(
                              '隐患等级',
                              style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(
                      initData.levelDesc ?? '-',
                      style: TextStyle(color: getLevelTextBgColor(initData.level)),
                    ),
                  ),
                ],
              ),
              //拍照取证
              Container(
                child: GestureDetector(
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        flex: 3,
                        child: Container(
                          padding: const EdgeInsets.only(left: 10, top: 10),
                          height: 50,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: const <Widget>[
                              Expanded(
                                child: Text(
                                  '现场照片',
                                  textAlign: TextAlign.left,
                                  style: TextStyle(
                                    fontWeight: FontWeight.w500,
                                    fontSize: 18,
                                  ),
                                ),
                                flex: 9,
                              ),
                            ],
                          ),
                        ),
                      ),
                      Expanded(
                        flex: 7,
                        child: Container(
                          child: Wrap(
                              direction: Axis.horizontal,
                              spacing: -25.0, // 主轴(水平)方向间距
                              // runSpacing: 20.0, // 纵轴（垂直）方向间距
                              alignment: WrapAlignment.end, //沿主轴方向居中
                              children: initData.photoUrls != null
                                  ? initData.photoUrls.map((f) {
                                      return Column(
                                        mainAxisAlignment: MainAxisAlignment.end,
                                        children: <Widget>[
                                          Container(
                                            width: 40,
                                            height: 40,
                                            //  margin: EdgeInsets.only(right: 5),
                                            decoration: BoxDecoration(
                                                color: Colors.transparent,
                                                borderRadius: const BorderRadius.all(Radius.circular(20.0)),
                                                image: DecorationImage(image: NetworkImage(f), fit: BoxFit.cover)),
                                          ),
                                        ],
                                      );
                                    }).toList()
                                  : []),
                        ),
                      ),
                      Expanded(
                        flex: 1,
                        child: Container(
                          child: Icon(
                            Icons.keyboard_arrow_right,
                            color: Theme.of(context).primaryColor,
                            size: 22,
                          ),
                        ),
                      ),
                    ],
                  ),
                  onTap: () {
                    Navigator.push(context, MaterialPageRoute(builder: (context) {
                      return PhotoViewPage(initData.photoUrls);
                    }));
                  },
                ),
              ),

              Container(
                color: Colors.grey[100],
                height: 10,
              ),

              //执行日志
              Container(
                padding: const EdgeInsets.only(left: 15),
                width: MediaQuery.of(context).size.width,
                height: 55,
                child: GestureDetector(
                  child: Row(
                    children: <Widget>[
                      const Expanded(
                        child: Text('执行日志',
                            textAlign: TextAlign.left,
                            style: TextStyle(
                              fontWeight: FontWeight.w500,
                              fontSize: 19,
                            )),
                        flex: 9,
                      ),
                      Expanded(
                        child: Icon(
                          Icons.keyboard_arrow_right,
                          color: Theme.of(context).primaryColor,
                        ),
                        flex: 1,
                      ),
                    ],
                  ),
                  onTap: () {
                    Navigator.push(context, MaterialPageRoute(builder: (context) {
                      return HidenDangerFlowRecord(initData.dangerId);
                    }));
                  },
                ),
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }
}
