import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/CheckItem.dart';
import '../../view/move_inspection/check_item_list.dart';

class CheckItemSet extends StatefulWidget {
  CheckItemSet(this.selectedCheckItem);

  List<CheckItem> selectedCheckItem;

  @override
  _CheckItemSetScreenState createState() =>
      _CheckItemSetScreenState(selectedCheckItem);
}

class _CheckItemSetScreenState extends State<CheckItemSet>
    with AutomaticKeepAliveClientMixin {
  final TextEditingController _searchController = TextEditingController();

  List<CheckItem> selectedCheckItem;

  String keyWords = '';

  List<CheckItem> filterItems = [];

  _CheckItemSetScreenState(this.selectedCheckItem);

  String theme = '';

  @override
  bool get wantKeepAlive => true;

  @override
  void initState() {
    super.initState();
    setState(() {
      selectedCheckItem ??= [];
      filterItems = selectedCheckItem;
    });

    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme =
            preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }

    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '检查项设置',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
        actions: <Widget>[
          IconButton(
            icon: Icon(
              Icons.add,
              color: Theme.of(context).primaryColor,
            ),
            onPressed: () {
              Navigator.push(context, MaterialPageRoute(builder: (context) {
                return CheckItemList(selectedCheckItem);
              })).then((data) {
                setState(() {
                  selectedCheckItem = data ?? [];
                  filterItems = selectedCheckItem;
                });
              });
            },
          ),
          IconButton(
            icon: Icon(
              Icons.check,
              color: Theme.of(context).primaryColor,
            ),
            onPressed: () {
              Navigator.pop(context, selectedCheckItem);
            },
          )
        ],
      ),
      body: ListView.builder(
          itemCount: 1,
          itemBuilder: (BuildContext context, int index) {
            return Column(
              children: <Widget>[
                Container(
                    height: 45,
                    width: double.infinity,
                    margin: const EdgeInsets.only(top: 3, left: 10, right: 10),
                    decoration: BoxDecoration(
                      color: Colors.grey[100],
                      borderRadius: const BorderRadius.all(Radius.circular(6.0)),
                    ),
                    child: Container(
                      padding: const EdgeInsets.only(left: 5),
                      child: TextField(
                          onChanged: (val) {
                            setState(() {
                              keyWords = val;
                              // 筛选
                              Iterable<CheckItem> skip =
                                  selectedCheckItem.where((f) {
                                return f.name.contains(keyWords);
                              });
                              filterItems = skip.toList();
                            });
                          },
                          controller: _searchController,
                          autofocus: false,
                          style: const TextStyle(fontSize: 18.0, color: Colors.black),
                          decoration: const InputDecoration(
                              border: InputBorder.none, hintText: '巡检点名称+编号')),
                    )),
                Column(
                  children: filterItems.map((f) {
                    return Card(
                      elevation: 0.2,
                      margin: const EdgeInsets.only(top: 5, left: 10, right: 10),
                      child: ListTile(
                        title: Text(
                          f.name,
                          style: const TextStyle(
                              fontSize: 16.0, fontWeight: FontWeight.w500),
                        ),
                        trailing: GestureDetector(
                          child: Icon(
                            Icons.close,
                            color: Theme.of(context).primaryColor,
                            size: 16,
                          ),
                          onTap: () {
                            setState(() {
                              selectedCheckItem.remove(f);
                              filterItems = selectedCheckItem;
                            });
                          },
                        ),
                      ),
                    );
                  }).toList(),
                ),
              ],
            );
          }),
    );
  }
}
