import 'package:amos_flutter_ui/message/flutter_toast.dart';
import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../services/no_plan_inspection.dart';
import '../CheckExecute/navigation_checkexec.dart';

class ManualInput extends StatefulWidget {
  final num taskId;

  const ManualInput({this.taskId});

  @override
  State<StatefulWidget> createState() => _ManualInputState();
}

class _ManualInputState extends State<ManualInput> {
  final TextEditingController _controller = TextEditingController();

  String theme = '';

  Future<void> initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  void initState() {
    super.initState();
    initThemeConfig();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: Colors.black54,
        appBar: AppBar(
          title: const Text(
            '输入二维码编号',
            style: TextStyle(color: Colors.white, fontSize: 18),
          ),
          centerTitle: true,
          elevation: 0,
          backgroundColor: Colors.black54,
        ),
        body: Container(
            color: Colors.black54,
            child: Padding(
              padding: const EdgeInsets.only(top: 100, left: 30, right: 30),
              child: Column(
                children: <Widget>[
                  Container(
                    decoration: BoxDecoration(
                      border: Border.all(
                        color: Colors.grey[300],
                        width: 1,
                      ),
                      borderRadius: const BorderRadius.all(Radius.circular(5)),
                    ),
                    child: TextField(
                        controller: _controller,
                        autofocus: false,
                        style: const TextStyle(fontSize: 18.0, color: Colors.white),
                        decoration: const InputDecoration(
                            border: OutlineInputBorder(borderSide: BorderSide.none),
                            contentPadding: EdgeInsets.all(10.0),
                            fillColor: Colors.black)),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      ElevatedButton(
                        child: const Padding(
                          padding: EdgeInsets.symmetric(horizontal: 40,vertical: 10),
                          child: Text(
                            '确定',
                            style: TextStyle(color: Colors.white),
                          ),
                        ),
                        onPressed: () {
                          String code = _controller.text;
                          if (code.isNotEmpty) {
                            FocusScope.of(context).requestFocus(FocusNode());
                            getContent(code);
                          } else {
                            shortMessage('请输入输入二维码编号！');
                          }
                        },
                      ),
                      const Padding(
                        padding: EdgeInsets.symmetric(vertical: 100),
                      )
                    ],
                  )
                ],
              ),
            )));
  }

  Future<void> getContent(String no) async {
    await getQueryPlanTaskBySerialInfo(1, no, null).then((data) {
      if (data != null && data.success) {
        Navigator.push(context, MaterialPageRoute(builder: (context) {
          return NavigationCheckExec(data.id, pointName: data.name, checkMode: 'OTHER');
        }));
      } else {
        shortMessage(data.message);
      }
    });
  }
}
